/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.collections.MultiMap;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IErrorMessageSource;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.Validatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.rest.annotations.AuthorizeInvocation;
import org.wicketstuff.rest.annotations.MethodMapping;
import org.wicketstuff.rest.contenthandling.IWebSerialDeserial;
import org.wicketstuff.rest.resource.MethodMappingInfo;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;
import org.wicketstuff.rest.utils.http.HttpMethod;
import org.wicketstuff.rest.utils.http.HttpUtils;
import org.wicketstuff.rest.utils.reflection.MethodParameter;
import org.wicketstuff.rest.utils.reflection.ReflectionUtils;
import org.wicketstuff.rest.utils.wicket.AttributesWrapper;
import org.wicketstuff.rest.utils.wicket.MethodParameterContext;
import org.wicketstuff.rest.utils.wicket.bundle.DefaultBundleResolver;

public abstract class AbstractRestResource<T extends IWebSerialDeserial>
implements IResource {
    public static final String NO_SUITABLE_METHOD_FOUND = "No suitable method found.";
    public static final String USER_IS_NOT_ALLOWED = "User is not allowed to use this resource.";
    private static final Logger log = LoggerFactory.getLogger(AbstractRestResource.class);
    private final Map<String, List<MethodMappingInfo>> mappedMethods;
    private final Map<String, IValidator> declaredValidators = new HashMap<String, IValidator>();
    private final T webSerialDeserial;
    private final IRoleCheckingStrategy roleCheckingStrategy;
    private final IErrorMessageSource bundleResolver;

    public AbstractRestResource(T serialDeserial) {
        this(serialDeserial, null);
    }

    public AbstractRestResource(T serialDeserial, IRoleCheckingStrategy roleCheckingStrategy) {
        Args.notNull(serialDeserial, (String)"serialDeserial");
        this.configureObjSerialDeserial(serialDeserial);
        this.onInitialize(serialDeserial);
        this.webSerialDeserial = serialDeserial;
        this.roleCheckingStrategy = roleCheckingStrategy;
        this.mappedMethods = this.loadAnnotatedMethods();
        this.bundleResolver = new DefaultBundleResolver(this.loadBoundleClasses());
    }

    private List<Class<?>> loadBoundleClasses() {
        Collection<IValidator> validators = this.declaredValidators.values();
        List<Class<?>> validatorsClasses = ReflectionUtils.getElementsClasses(validators);
        validatorsClasses.add(this.getClass());
        return validatorsClasses;
    }

    public final void respond(IResource.Attributes attributes) {
        AttributesWrapper attributesWrapper = new AttributesWrapper(attributes);
        WebResponse response = attributesWrapper.getWebResponse();
        HttpMethod httpMethod = attributesWrapper.getHttpMethod();
        MethodMappingInfo mappedMethod = this.selectMostSuitedMethod(attributesWrapper);
        if (mappedMethod != null) {
            this.handleMethodExecution(attributesWrapper, mappedMethod);
        } else {
            this.noSuitableMethodFound(response, httpMethod);
        }
    }

    private void handleMethodExecution(AttributesWrapper attributesWrapper, MethodMappingInfo mappedMethod) {
        WebResponse response = attributesWrapper.getWebResponse();
        HttpMethod httpMethod = attributesWrapper.getHttpMethod();
        IResource.Attributes attributes = attributesWrapper.getOriginalAttributes();
        String outputFormat = mappedMethod.getOutputFormat();
        if (!this.isUserAuthorized(mappedMethod.getRoles())) {
            response.write((CharSequence)USER_IS_NOT_ALLOWED);
            response.setStatus(401);
            return;
        }
        List parametersValues = this.extractMethodParameters(mappedMethod, attributesWrapper);
        if (parametersValues == null) {
            this.noSuitableMethodFound(response, httpMethod);
            return;
        }
        List<IValidationError> validationErrors = this.validateMethodParameters(mappedMethod, parametersValues);
        if (validationErrors.size() > 0) {
            IValidationError error = validationErrors.get(0);
            Serializable message = error.getErrorMessage(this.bundleResolver);
            this.webSerialDeserial.objectToResponse(message, response, outputFormat);
            response.setStatus(400);
            return;
        }
        this.onBeforeMethodInvoked(mappedMethod, attributes);
        Object result = this.invokeMappedMethod(mappedMethod.getMethod(), parametersValues, response);
        this.onAfterMethodInvoked(mappedMethod, attributes, result);
        response.setContentType(outputFormat);
        if (result != null) {
            this.objectToResponse(result, response, outputFormat);
        }
    }

    private boolean isUserAuthorized(Roles roles) {
        if (roles.isEmpty()) {
            return true;
        }
        return this.roleCheckingStrategy.hasAnyRole(roles);
    }

    public void noSuitableMethodFound(WebResponse response, HttpMethod httpMethod) {
        response.setStatus(400);
        response.write((CharSequence)("No suitable method found. URL '" + AbstractRestResource.extractUrlFromRequest() + "' and HTTP method " + (Object)((Object)httpMethod)));
    }

    private List<IValidationError> validateMethodParameters(MethodMappingInfo mappedMethod, List parametersValues) {
        List<MethodParameter> methodParameters = mappedMethod.getMethodParameters();
        ArrayList<IValidationError> errors = new ArrayList<IValidationError>();
        for (MethodParameter methodParameter : methodParameters) {
            int i = methodParameters.indexOf(methodParameter);
            String validatorKey = methodParameter.getValdatorKey();
            IValidator validator = this.getValidator(validatorKey);
            Validatable validatable = new Validatable(parametersValues.get(i));
            if (validator != null) {
                validator.validate((IValidatable)validatable);
                errors.addAll(validatable.getErrors());
                continue;
            }
            if (Strings.isEmpty((CharSequence)validatorKey)) continue;
            log.debug("No validator found for key '" + validatorKey + "'");
        }
        return errors;
    }

    protected void onBeforeMethodInvoked(MethodMappingInfo mappedMethod, IResource.Attributes attributes) {
    }

    protected void onAfterMethodInvoked(MethodMappingInfo mappedMethod, IResource.Attributes attributes, Object result) {
    }

    public void objectToResponse(Object result, WebResponse response, String mimeType) {
        try {
            this.webSerialDeserial.objectToResponse(result, response, mimeType);
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing object to response.", e);
        }
    }

    private MethodMappingInfo selectMostSuitedMethod(AttributesWrapper attributesWrapper) {
        int indexedParamCount = attributesWrapper.getPageParameters().getIndexedCount();
        PageParameters pageParameters = attributesWrapper.getPageParameters();
        List<MethodMappingInfo> mappedMethodsCandidates = this.mappedMethods.get(indexedParamCount + "_" + (Object)((Object)attributesWrapper.getHttpMethod()));
        MultiMap mappedMethodByScore = new MultiMap();
        int highestScore = 0;
        if (mappedMethodsCandidates == null || mappedMethodsCandidates.size() == 0) {
            return null;
        }
        for (MethodMappingInfo mappedMethod : mappedMethodsCandidates) {
            List<AbstractURLSegment> segments = mappedMethod.getSegments();
            int score = 0;
            for (AbstractURLSegment segment : segments) {
                int i;
                String currentActualSegment;
                int partialScore = segment.calculateScore(currentActualSegment = AbstractURLSegment.getActualSegment(pageParameters.get(i = segments.indexOf((Object)segment)).toString()));
                if (partialScore == 0) {
                    score = -1;
                    break;
                }
                score += partialScore;
            }
            if (score < highestScore) continue;
            highestScore = score;
            mappedMethodByScore.addValue((Object)score, (Object)mappedMethod);
        }
        if (mappedMethodByScore.get((Object)highestScore) != null && ((List)mappedMethodByScore.get((Object)highestScore)).size() > 1) {
            this.throwAmbiguousMethodsException((List)mappedMethodByScore.get((Object)highestScore));
        }
        return (MethodMappingInfo)mappedMethodByScore.getFirstValue((Object)highestScore);
    }

    private void throwAmbiguousMethodsException(List<MethodMappingInfo> list) {
        WebRequest request = AbstractRestResource.getCurrentWebRequest();
        String methodsNames = "";
        for (MethodMappingInfo urlMappingInfo : list) {
            if (!methodsNames.isEmpty()) {
                methodsNames = methodsNames + ", ";
            }
            methodsNames = methodsNames + urlMappingInfo.getMethod().getName();
        }
        throw new WicketRuntimeException("Ambiguous methods mapped for the current request: URL '" + request.getClientUrl() + "', HTTP method " + (Object)((Object)HttpUtils.getHttpMethod(request)) + ". " + "Mapped methods: " + methodsNames);
    }

    @Deprecated
    protected void configureObjSerialDeserial(T objSerialDeserial) {
    }

    protected void onInitialize(T objSerialDeserial) {
    }

    private Map<String, List<MethodMappingInfo>> loadAnnotatedMethods() {
        Method[] methods = this.getClass().getDeclaredMethods();
        MultiMap mappedMethods = new MultiMap();
        boolean isUsingAuthAnnot = false;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            MethodMapping methodMapped = method.getAnnotation(MethodMapping.class);
            AuthorizeInvocation authorizeInvocation = method.getAnnotation(AuthorizeInvocation.class);
            boolean bl = isUsingAuthAnnot = isUsingAuthAnnot || authorizeInvocation != null;
            if (methodMapped == null) continue;
            HttpMethod httpMethod = methodMapped.httpMethod();
            MethodMappingInfo methodMappingInfo = new MethodMappingInfo(methodMapped, method);
            if (!this.webSerialDeserial.isMimeTypeSupported(methodMappingInfo.getInputFormat()) || !this.webSerialDeserial.isMimeTypeSupported(methodMappingInfo.getOutputFormat())) {
                throw new WicketRuntimeException("Mapped methods use a MIME type not supported by obj serializer/deserializer!");
            }
            mappedMethods.addValue((Object)(methodMappingInfo.getSegmentsCount() + "_" + httpMethod.getMethod()), (Object)methodMappingInfo);
        }
        if (isUsingAuthAnnot && this.roleCheckingStrategy == null) {
            throw new WicketRuntimeException("Annotation AuthorizeInvocation is used but no role-checking strategy has been set for the controller!");
        }
        return this.makeListMapImmutable((Map)mappedMethods);
    }

    private <T, E> Map<T, List<E>> makeListMapImmutable(Map<T, List<E>> listMap) {
        for (T key : listMap.keySet()) {
            listMap.put(key, Collections.unmodifiableList(listMap.get(key)));
        }
        return Collections.unmodifiableMap(listMap);
    }

    private List extractMethodParameters(MethodMappingInfo mappedMethod, AttributesWrapper attributesWrapper) {
        ArrayList<Object> parametersValues = new ArrayList<Object>();
        PageParameters pageParameters = attributesWrapper.getPageParameters();
        LinkedHashMap<String, String> pathParameters = mappedMethod.populatePathParameters(pageParameters);
        MethodParameterContext parameterContext = new MethodParameterContext(attributesWrapper, pathParameters, (IWebSerialDeserial)this.webSerialDeserial);
        for (MethodParameter methodParameter : mappedMethod.getMethodParameters()) {
            Object paramValue = methodParameter.extractParameterValue(parameterContext);
            if (paramValue == null && methodParameter.isRequired()) {
                return null;
            }
            parametersValues.add(paramValue);
        }
        return parametersValues;
    }

    private Object invokeMappedMethod(Method method, List<?> parametersValues, WebResponse response) {
        try {
            return method.invoke((Object)this, parametersValues.toArray());
        }
        catch (Exception exception) {
            this.handleException(response, exception);
            log.debug("Error invoking method '" + method.getName() + "'");
            return null;
        }
    }

    protected void handleException(WebResponse response, Exception exception) {
        response.setStatus(500);
        response.write((CharSequence)"General server error.");
    }

    public static Url extractUrlFromRequest() {
        return RequestCycle.get().getRequest().getClientUrl();
    }

    public <T> T requestToObject(WebRequest request, Class<T> argClass, String mimeType) {
        try {
            return this.webSerialDeserial.requestToObject(request, argClass, mimeType);
        }
        catch (Exception e) {
            log.debug("Error deserializing object from request");
            return null;
        }
    }

    public static final WebRequest getCurrentWebRequest() {
        return (WebRequest)RequestCycle.get().getRequest();
    }

    public static Object toObject(Class clazz, String value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        try {
            IConverter converter = Application.get().getConverterLocator().getConverter(clazz);
            return converter.convertToObject(value, Session.get().getLocale());
        }
        catch (Exception e) {
            WebResponse response = AbstractRestResource.getCurrentWebResponse();
            response.setStatus(400);
            log.debug("Could not find a suitable converter for value '" + value + "' of type '" + clazz + "'");
            return null;
        }
    }

    public static final WebResponse getCurrentWebResponse() {
        return (WebResponse)RequestCycle.get().getResponse();
    }

    protected final void setResponseStatusCode(int statusCode) {
        try {
            AbstractRestResource.getCurrentWebResponse().setStatus(statusCode);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not find a suitable WebResponse object for the current ThreadContext.", e);
        }
    }

    protected Map<String, List<MethodMappingInfo>> getMappedMethods() {
        return this.mappedMethods;
    }

    protected void registerValidator(String key, IValidator validator) {
        this.declaredValidators.put(key, validator);
    }

    protected void unregisterValidator(String key) {
        this.declaredValidators.remove(key);
    }

    protected IValidator getValidator(String key) {
        return this.declaredValidators.get(key);
    }
}

