/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource.urlsegments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;

public class MultiParamSegment
extends AbstractURLSegment {
    private volatile List<AbstractURLSegment> subSegments;

    MultiParamSegment(String text) {
        super(text);
    }

    private List<AbstractURLSegment> loadSubSegments(String text) {
        Matcher matcher = SEGMENT_PARAMETER.matcher((CharSequence)text);
        ArrayList<AbstractURLSegment> subSegments = new ArrayList<AbstractURLSegment>();
        int fixedTextIndex = 0;
        while (matcher.find()) {
            String group = matcher.group();
            AbstractURLSegment segment = AbstractURLSegment.newSegment(group);
            String fixedText = text.substring(fixedTextIndex, matcher.start());
            fixedTextIndex = matcher.end();
            if (!fixedText.isEmpty()) {
                subSegments.add(AbstractURLSegment.newSegment(fixedText));
            }
            subSegments.add(segment);
        }
        if (fixedTextIndex < text.length()) {
            String fixedText = text.substring(fixedTextIndex, text.length());
            subSegments.add(AbstractURLSegment.newSegment(fixedText));
        }
        return subSegments;
    }

    @Override
    protected MetaPattern loadMetaPattern() {
        ArrayList<MetaPattern> patterns = new ArrayList<MetaPattern>();
        this.subSegments = Collections.unmodifiableList(this.loadSubSegments(this.toString()));
        for (AbstractURLSegment segment : this.subSegments) {
            patterns.add(segment.getMetaPattern());
        }
        return new MetaPattern(patterns);
    }

    @Override
    public int calculateScore(String actualSegment) {
        Matcher matcher = this.getMetaPattern().matcher((CharSequence)actualSegment);
        return matcher.matches() ? 1 : 0;
    }

    @Override
    public void populatePathVariables(Map<String, String> variables, String segment) {
        int startingIndex = 0;
        if (!this.getMetaPattern().matcher((CharSequence)segment).matches()) {
            return;
        }
        for (AbstractURLSegment subSegment : this.subSegments) {
            MetaPattern pattern = subSegment.getMetaPattern();
            Matcher matcher = pattern.matcher((CharSequence)(segment = segment.substring(startingIndex)));
            if (!matcher.find()) continue;
            String group = matcher.group();
            subSegment.populatePathVariables(variables, group);
            startingIndex = matcher.end();
        }
    }

    public List<AbstractURLSegment> getSubSegments() {
        return this.subSegments;
    }
}

