/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.utils.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.wicketstuff.rest.annotations.parameters.AnnotatedParam;

public class ReflectionUtils {
    public static boolean isParameterAnnotatedWith(int i, Method method, Class<? extends Annotation> targetAnnotation) {
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        if (parametersAnnotations.length == 0) {
            return false;
        }
        Annotation[] parameterAnnotations = parametersAnnotations[i];
        for (int j = 0; j < parameterAnnotations.length; ++j) {
            Annotation annotation = parameterAnnotations[j];
            if (!targetAnnotation.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public static Annotation getAnnotationParam(int i, Method method) {
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        if (parametersAnnotations.length == 0) {
            return null;
        }
        Annotation[] parameterAnnotations = parametersAnnotations[i];
        for (int j = 0; j < parameterAnnotations.length; ++j) {
            Annotation annotation = parameterAnnotations[j];
            AnnotatedParam isAnnotatedParam = annotation.annotationType().getAnnotation(AnnotatedParam.class);
            if (isAnnotatedParam == null) continue;
            return annotation;
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(Annotation[] parameterAnnotations, Class<T> targetAnnotation) {
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation annotation = parameterAnnotations[i];
            if (!targetAnnotation.isInstance(annotation)) continue;
            return (T)((Annotation)targetAnnotation.cast(annotation));
        }
        return null;
    }

    public static <T extends Annotation> T findMethodParameterAnnotation(Method ownerMethod, int paramIndex, Class<T> targetAnnotation) {
        Annotation[][] paramAnnotations = ownerMethod.getParameterAnnotations();
        return ReflectionUtils.findAnnotation(paramAnnotations[paramIndex], targetAnnotation);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T invokeMethod(Object target, String name, Class<?> ... parameterTypes) {
        Method method = ReflectionUtils.findMethod(target.getClass(), name, parameterTypes);
        try {
            return (T)method.invoke(target, (Object[])parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getAnnotationField(Annotation annotation, String fieldName, T defaultValue) {
        T methodResult = null;
        if (annotation != null) {
            methodResult = ReflectionUtils.invokeMethod(annotation, fieldName, new Class[0]);
        }
        return methodResult != null ? methodResult : (T)defaultValue;
    }

    public static List<Class<?>> getElementsClasses(Collection<?> collection) {
        ArrayList targetClasses = new ArrayList();
        for (Object element : collection) {
            targetClasses.add(element.getClass());
        }
        return targetClasses;
    }
}

