/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.utils.wicket.bundle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.validation.IErrorMessageSource;
import org.wicketstuff.rest.utils.wicket.bundle.StringConverterInterpolator;

public class DefaultBundleResolver
implements IErrorMessageSource {
    private final List<Class<?>> targetClasses;

    public DefaultBundleResolver(Class<?> ... targetClasses) {
        this.targetClasses = Collections.unmodifiableList(Arrays.asList(targetClasses));
    }

    public DefaultBundleResolver(List<Class<?>> targetClasses) {
        this.targetClasses = Collections.unmodifiableList(targetClasses);
    }

    public String getMessage(String key, Map<String, Object> vars) {
        String resourceValue = null;
        List resourceLoaders = Application.get().getResourceSettings().getStringResourceLoaders();
        Locale locale = Session.get().getLocale();
        String style = Session.get().getStyle();
        block0: for (IStringResourceLoader stringResourceLoader : resourceLoaders) {
            for (Class<?> clazz : this.targetClasses) {
                resourceValue = stringResourceLoader.loadStringResource(clazz, key, locale, style, null);
                if (resourceValue == null) continue;
                break block0;
            }
        }
        StringConverterInterpolator interpolator = new StringConverterInterpolator(resourceValue != null ? resourceValue : "", vars, false, locale);
        return interpolator.toString();
    }
}

