/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource.urlsegments.visitor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.util.string.StringValue;
import org.wicketstuff.rest.resource.MethodMappingInfo;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;
import org.wicketstuff.rest.resource.urlsegments.FixedURLSegment;
import org.wicketstuff.rest.resource.urlsegments.MultiParamSegment;
import org.wicketstuff.rest.resource.urlsegments.ParamSegment;
import org.wicketstuff.rest.resource.urlsegments.visitor.ISegmentVisitor;
import org.wicketstuff.rest.utils.collection.CollectionUtils;

public class ScoreMethodAndExtractPathVars
implements ISegmentVisitor {
    private final PageParameters pageParameters;
    private final MethodMappingInfo methodInfo;
    private final Map<String, String> pathVariables;
    private int score;
    private boolean isSegmentValid = false;

    public ScoreMethodAndExtractPathVars(MethodMappingInfo methodInfo, PageParameters pageParameters) {
        this.methodInfo = methodInfo;
        this.pageParameters = pageParameters;
        this.pathVariables = new LinkedHashMap<String, String>();
    }

    @Override
    public void visit(FixedURLSegment segment) {
        String segmentValue = this.segmentActualValue(segment);
        this.isSegmentValid = segmentValue.equals(segment.toString());
        if (this.isSegmentValid) {
            this.addScore(2);
        }
    }

    @Override
    public void visit(MultiParamSegment segment) {
        String segmentValue = this.segmentActualValue(segment);
        MetaPattern metaPatternWithGroups = segment.getMetaPatternWithGroups();
        Matcher matcher = metaPatternWithGroups.matcher((CharSequence)segmentValue);
        this.isSegmentValid = matcher.matches();
        if (this.isSegmentValid) {
            ArrayList paramSegments = new ArrayList();
            CollectionUtils.filterCollectionByType(segment.getSubSegments(), paramSegments, ParamSegment.class);
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String group = matcher.group(i);
                String groupName = ((ParamSegment)paramSegments.get(i - 1)).getParamName();
                this.addPathVariable(groupName, group);
            }
            this.addScore(1);
        }
    }

    @Override
    public void visit(ParamSegment segment) {
        String segmentValue = this.segmentActualValue(segment);
        Matcher matcher = segment.getMetaPattern().matcher((CharSequence)segmentValue);
        this.isSegmentValid = matcher.matches();
        if (this.isSegmentValid) {
            this.addScore(1);
            this.addPathVariable(segment.getParamName(), matcher.group());
        }
    }

    protected String segmentActualValue(AbstractURLSegment segment) {
        int i = this.methodInfo.getSegments().indexOf(segment);
        StringValue pageParameter = this.pageParameters.get(i);
        return AbstractURLSegment.getActualSegment(pageParameter.toString());
    }

    public boolean isSegmentValid() {
        return this.isSegmentValid;
    }

    public void addScore(int partialSocre) {
        this.score += partialSocre;
    }

    public int getScore() {
        return this.score;
    }

    public MethodMappingInfo getMethodInfo() {
        return this.methodInfo;
    }

    public Map<String, String> getPathVariables() {
        return this.pathVariables;
    }

    public void addPathVariable(String name, String value) {
        this.pathVariables.put(name, value);
    }
}

