/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.fast2;

import org.apache.wicket.serialize.ISerializer;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTSerialisationListener;
import org.wicketstuff.pageserializer.common.listener.ISerializationListener;
import org.wicketstuff.pageserializer.fast2.Fast2WicketSerialException;

public class Fast2WicketSerializer
implements ISerializer {
    private final FSTConfiguration fastSerializationConfig;
    private ISerializationListener listener;

    public Fast2WicketSerializer() {
        this(Fast2WicketSerializer.getDefaultFSTConfiguration());
    }

    public Fast2WicketSerializer(FSTConfiguration config) {
        this.fastSerializationConfig = config;
    }

    public static final FSTConfiguration getDefaultFSTConfiguration() {
        FSTConfiguration config = FSTConfiguration.createDefaultConfiguration();
        config.setForceSerializable(false);
        return config;
    }

    public byte[] serialize(Object object) {
        Exception exception = null;
        try {
            FSTObjectOutput out = this.fastSerializationConfig.getObjectOutput();
            if (this.listener != null) {
                out.setListener((FSTSerialisationListener)new ListenerAdapter(this.listener));
                this.listener.begin(object);
            }
            out.writeObject(object);
            out.setListener(null);
            byte[] byArray = out.getCopyOfWrittenBuffer();
            return byArray;
        }
        catch (Exception e) {
            exception = e;
            throw new Fast2WicketSerialException(String.format("Unable to serialize the object %1$s", object), e);
        }
        finally {
            if (this.listener != null) {
                this.listener.end(object, exception);
            }
        }
    }

    public Fast2WicketSerializer setListener(ISerializationListener listener) {
        this.listener = listener;
        return this;
    }

    public ISerializationListener getListener() {
        return this.listener;
    }

    public Object deserialize(byte[] data) {
        try {
            return this.fastSerializationConfig.getObjectInput(data).readObject();
        }
        catch (Exception e) {
            throw new Fast2WicketSerialException("Unable to deserialize the data", e);
        }
    }

    static class ListenerAdapter
    implements FSTSerialisationListener {
        private final ISerializationListener listener;

        public ListenerAdapter(ISerializationListener listener) {
            this.listener = listener;
        }

        public void objectWillBeWritten(Object obj, int streamPosition) {
            this.listener.before(streamPosition, obj);
        }

        public void objectHasBeenWritten(Object obj, int oldStreamPosition, int streamPosition) {
            this.listener.after(streamPosition, obj);
        }
    }
}

