/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.apt;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.GenericVisitorAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.tools.JavaFileObject;
import org.wikbook.apt.Data;
import org.wikbook.apt.StringBrowser;
import org.wikbook.apt.annotations.Documented;
import org.wikbook.apt.model.Catalog;
import org.wikbook.apt.model.Fragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CatalogBuilder
extends GenericVisitorAdapter<Void, Data> {
    private final Catalog catalog = new Catalog();

    CatalogBuilder() {
    }

    public void build(String annoationId, String fragmentId, JavaFileObject jfo) throws IOException, ParseException {
        Data data = new Data(fragmentId, annoationId, "" + jfo.getCharContent(true));
        CompilationUnit cu = JavaParser.parse((InputStream)jfo.openInputStream());
        cu.accept((GenericVisitor)this, (Object)data);
    }

    public Void visit(ClassOrInterfaceDeclaration n, Data arg) {
        this.is((BodyDeclaration)n, arg);
        return (Void)super.visit(n, (Object)arg);
    }

    public Void visit(EnumDeclaration n, Data arg) {
        this.is((BodyDeclaration)n, arg);
        return (Void)super.visit(n, (Object)arg);
    }

    public Void visit(ConstructorDeclaration n, Data arg) {
        this.is((BodyDeclaration)n, arg);
        return (Void)super.visit(n, (Object)arg);
    }

    public Void visit(FieldDeclaration n, Data arg) {
        this.is((BodyDeclaration)n, arg);
        return (Void)super.visit(n, (Object)arg);
    }

    public Void visit(MethodDeclaration n, Data arg) {
        this.is((BodyDeclaration)n, arg);
        return (Void)super.visit(n, (Object)arg);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    private void is(BodyDeclaration body, Data arg) {
        List annotations = body.getAnnotations();
        if (annotations != null) {
            for (AnnotationExpr ae : annotations) {
                if (!ae.getName().getName().equals(Documented.class.getSimpleName())) continue;
                boolean found = false;
                if (ae instanceof MarkerAnnotationExpr) {
                    found = arg.annotationId.length() == 0;
                } else {
                    String id;
                    NormalAnnotationExpr nae = (NormalAnnotationExpr)ae;
                    if (nae.getPairs() == null || nae.getPairs().size() == 0) {
                        id = "";
                    } else {
                        MemberValuePair mvp = (MemberValuePair)nae.getPairs().get(0);
                        id = ((StringLiteralExpr)mvp.getValue()).getValue();
                    }
                    found = id.equals(arg.fragmentId);
                }
                if (!found) continue;
                StringBrowser sb = new StringBrowser(arg.fileContent);
                int from = sb.getOffset(body.getBeginLine() - 1, 0);
                int to = sb.getOffset(body.getEndLine(), 0);
                char[] chars = arg.fileContent.substring(from, to).toCharArray();
                int o1 = sb.getOffset(ae.getBeginLine() - 1, ae.getBeginColumn()) - from - 1;
                int o2 = sb.getOffset(ae.getEndLine() - 1, ae.getEndColumn()) - from;
                for (int i = o1; i < o2; ++i) {
                    chars[i] = 32;
                }
                String fragment = new String(chars);
                this.catalog.addFragment(arg.fragmentId, new Fragment("", fragment));
            }
        }
    }
}

