/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.apt.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wikbook.apt.model.Fragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Catalog
implements Serializable {
    private final HashMap<String, List<Fragment>> fragmentsById = new HashMap();

    public void merge(Catalog catalog) {
        for (Map.Entry<String, List<Fragment>> entry : catalog.fragmentsById.entrySet()) {
            this.addFragment(entry.getKey(), entry.getValue());
        }
    }

    public Set<String> getIds() {
        return this.fragmentsById.keySet();
    }

    public void addFragment(String fragmentId, List<Fragment> fragment) {
        List<Fragment> fragments = this.fragmentsById.get(fragmentId);
        if (fragments == null) {
            fragments = new ArrayList<Fragment>();
            this.fragmentsById.put(fragmentId, fragments);
        }
        fragments.addAll(fragment);
    }

    public void addFragment(String fragmentId, Fragment fragment) {
        this.addFragment(fragmentId, Collections.singletonList(fragment));
    }

    public void addFragment(String fragmentId, String content) {
        this.addFragment(fragmentId, new Fragment(null, content));
    }

    public List<Fragment> getFragment(String fragmentId) {
        List<Fragment> list = this.fragmentsById.get(fragmentId);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public String toString() {
        return "Catalog[" + this.fragmentsById + "]";
    }
}

