/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

class StringClipper {
    private final String s;

    public StringClipper(String s) {
        if (s == null) {
            throw new NullPointerException("No null string accepted");
        }
        this.s = s;
    }

    public String clip(int fromLine, int fromColumn, int toLine, int toColumn) {
        int to;
        int from = this.getOffset(fromLine, fromColumn);
        if (from > (to = this.getOffset(toLine, toColumn))) {
            throw new IllegalArgumentException("Wrong clipping coordinates");
        }
        return this.s.substring(from, to);
    }

    public int getOffset(int lineOffset, int columnOffset) {
        int offset;
        if (lineOffset < 0) {
            throw new IllegalArgumentException("Line offset cannot be negative: " + lineOffset);
        }
        if (columnOffset < 0) {
            throw new IllegalArgumentException("Column offset cannot be negative: " + columnOffset);
        }
        for (offset = 0; (lineOffset != 0 || columnOffset != 0) && offset < this.s.length(); ++offset) {
            char next = this.s.charAt(offset);
            if (lineOffset > 0) {
                if (next != '\n') continue;
                --lineOffset;
                continue;
            }
            if (next == '\n' && columnOffset > 0) break;
            --columnOffset;
        }
        return offset;
    }
}

