/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import japa.parser.ParseException;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.AnnotationDeclaration;
import japa.parser.ast.body.AnnotationMemberDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.visitor.GenericVisitorAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.TypeDesc;
import org.wikbook.codesource.CodeSource;
import org.wikbook.codesource.CodeSourceBuilder;
import org.wikbook.codesource.CodeSourceException;
import org.wikbook.codesource.MemberKey;
import org.wikbook.codesource.MemberSource;
import org.wikbook.codesource.NamedMemberSource;
import org.wikbook.codesource.NoSuchSourceException;
import org.wikbook.codesource.Signature;
import org.wikbook.codesource.SignedMemberSource;
import org.wikbook.codesource.TypeSource;
import org.wikbook.codesource.Visit;
import org.wikbook.text.Clip;
import org.wikbook.text.TextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompilationUnitVisitor
extends GenericVisitorAdapter<Void, Visit> {
    private final CodeSourceBuilder builder;

    CompilationUnitVisitor(CodeSourceBuilder builder) {
        this.builder = builder;
    }

    Visit.CU visit(String compilationUnitPath) throws IOException, ParseException, CodeSourceException {
        InputStream cuis = this.builder.context.getResource(compilationUnitPath);
        if (cuis == null) {
            throw new NoSuchSourceException("Compilation path cannot be located " + compilationUnitPath);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[20];
        int l = cuis.read(buffer);
        while (l != -1) {
            baos.write(buffer, 0, l);
            l = cuis.read(buffer);
        }
        String s = baos.toString();
        Visit.CU visit = new Visit.CU(s);
        visit.accept(this);
        return visit;
    }

    private String toString(NameExpr n) {
        if (n instanceof QualifiedNameExpr) {
            QualifiedNameExpr qn = (QualifiedNameExpr)n;
            return qn.getQualifier() + "." + qn.getName();
        }
        return n.getName();
    }

    public Void visit(PackageDeclaration n, Visit arg) {
        ((Visit.CU)arg).pkg = this.toString(n.getName());
        return (Void)super.visit(n, (Object)arg);
    }

    private <D extends TypeDeclaration> Void visit(D declaration, Visit.TD visit, SuperVisit<D> superVisit) {
        String pkg = visit.getPkg();
        String fqn = visit.getFQN();
        String path = visit.getPath();
        InputStream in = this.builder.context.getResource(path);
        if (in == null) {
            throw new CodeSourceException("Cannot locate class file for fqn " + fqn + " with path " + path);
        }
        try {
            ClassFile cf = ClassFile.readFrom((InputStream)in);
            ArrayList<Signature> constructorSignatures = new ArrayList<Signature>();
            for (MethodInfo mi : cf.getConstructors()) {
                MethodDesc desc = mi.getMethodDescriptor();
                ArrayList<String> parameterTypes = new ArrayList<String>();
                for (TypeDesc typeDesc : desc.getParameterTypes()) {
                    parameterTypes.add(typeDesc.getFullName());
                }
                constructorSignatures.add(new Signature(parameterTypes));
            }
            ArrayList<Signature> methodSignatures = new ArrayList<Signature>();
            for (MethodInfo mi : cf.getMethods()) {
                MethodDesc desc = mi.getMethodDescriptor();
                ArrayList<String> parameterTypes = new ArrayList<String>();
                for (TypeDesc typeDesc : desc.getParameterTypes()) {
                    parameterTypes.add(typeDesc.getFullName());
                }
                methodSignatures.add(new Signature(parameterTypes));
            }
            visit.constructorSignatures = constructorSignatures.iterator();
            visit.methodSignatures = methodSignatures.iterator();
        }
        catch (IOException e) {
            throw new CodeSourceException("Could not load class " + fqn, e);
        }
        visit.stack.addLast(new LinkedList());
        Void ret = superVisit.visit(declaration, visit);
        List blah = visit.stack.removeLast();
        Clip typeClip = Clip.get(declaration.getBeginLine() - 1, 0, declaration.getEndLine() - 1, declaration.getEndColumn());
        TypeSource typeSource = new TypeSource(new TextArea(visit.getCU().source), fqn, typeClip, visit.javaDoc((BodyDeclaration)declaration));
        for (CodeSource source : blah) {
            MemberSource methodSource = (MemberSource)source;
            typeSource.addMember(methodSource);
        }
        visit.getCU().types.add(typeSource);
        return ret;
    }

    public Void visit(ClassOrInterfaceDeclaration n, Visit v) {
        return this.visit(n, new Visit.TD(v, (TypeDeclaration)n), new SuperVisit<ClassOrInterfaceDeclaration>(){

            @Override
            public Void visit(ClassOrInterfaceDeclaration td, Visit v) {
                return (Void)CompilationUnitVisitor.super.visit(td, v);
            }
        });
    }

    public Void visit(EnumDeclaration n, Visit v) {
        return this.visit(n, new Visit.TD(v, (TypeDeclaration)n), new SuperVisit<EnumDeclaration>(){

            @Override
            public Void visit(EnumDeclaration td, Visit v) {
                return (Void)CompilationUnitVisitor.super.visit(td, v);
            }
        });
    }

    public Void visit(AnnotationDeclaration n, Visit v) {
        return this.visit(n, new Visit.TD(v, (TypeDeclaration)n), new SuperVisit<AnnotationDeclaration>(){

            @Override
            public Void visit(AnnotationDeclaration td, Visit v) {
                return (Void)CompilationUnitVisitor.super.visit(td, v);
            }
        });
    }

    private static Clip clip(BodyDeclaration body) {
        return Clip.get(body.getBeginLine() - 1, 0, body.getEndLine() - 1, body.getEndColumn());
    }

    public Void visit(FieldDeclaration n, Visit v) {
        if (n.getVariables().size() != 1) {
            throw new UnsupportedOperationException("todo");
        }
        VariableDeclarator declarator = (VariableDeclarator)n.getVariables().get(0);
        VariableDeclaratorId id = declarator.getId();
        NamedMemberSource fieldSource = new NamedMemberSource(id.getName(), CompilationUnitVisitor.clip((BodyDeclaration)n), v.javaDoc((BodyDeclaration)n));
        ((Visit.TD)v).stack.getLast().addLast(fieldSource);
        return (Void)super.visit(n, (Object)v);
    }

    public Void visit(AnnotationMemberDeclaration n, Visit v) {
        SignedMemberSource memberSource = new SignedMemberSource(MemberKey.createSignedKey(n.getName(), new String[0]), CompilationUnitVisitor.clip((BodyDeclaration)n), v.javaDoc((BodyDeclaration)n));
        ((Visit.TD)v).stack.getLast().addLast(memberSource);
        return (Void)super.visit(n, (Object)v);
    }

    public Void visit(ObjectCreationExpr n, Visit arg) {
        return null;
    }

    public Void visit(MethodDeclaration n, Visit v) {
        Iterator<Signature> signatures = ((Visit.TD)v).methodSignatures;
        if (!signatures.hasNext()) {
            throw new CodeSourceException("Did not find a method signature for declaration " + n.getName());
        }
        Signature signature = signatures.next();
        SignedMemberSource methodSource = new SignedMemberSource(new MemberKey(n.getName(), signature), CompilationUnitVisitor.clip((BodyDeclaration)n), v.javaDoc((BodyDeclaration)n));
        ((Visit.TD)v).stack.getLast().addLast(methodSource);
        return (Void)super.visit(n, (Object)v);
    }

    public Void visit(ConstructorDeclaration n, Visit v) {
        Iterator<Signature> signatures = ((Visit.TD)v).constructorSignatures;
        if (!signatures.hasNext()) {
            throw new CodeSourceException("Did not find a constructor signature for declaration " + n.getName());
        }
        Signature signature = signatures.next();
        SignedMemberSource methodSource = new SignedMemberSource(new MemberKey(n.getName(), signature), CompilationUnitVisitor.clip((BodyDeclaration)n), v.javaDoc((BodyDeclaration)n));
        ((Visit.TD)v).stack.getLast().addLast(methodSource);
        return (Void)super.visit(n, (Object)v);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SuperVisit<T extends TypeDeclaration> {
        public Void visit(T var1, Visit var2);
    }
}

