/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.model;

import java.util.Iterator;
import java.util.LinkedList;
import org.wikbook.model.DocbookElement;
import org.wikbook.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementContainer<E extends DocbookElement>
implements Iterable<E> {
    protected final LinkedList<E> elements = new LinkedList();
    private final Class<E> elementType;

    public ElementContainer(Class<E> elementType) {
        this.elementType = elementType;
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    public boolean isNotEmpty() {
        return !this.elements.isEmpty();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public E getLast() {
        return (E)((DocbookElement)this.elements.getLast());
    }

    public boolean append(DocbookElement elt) {
        if (this.elementType.isInstance(elt)) {
            this.elements.add(this.elementType.cast(elt));
            return true;
        }
        return false;
    }

    public void writeTo(XMLEmitter emitter) {
        for (DocbookElement elt : this.elements) {
            elt.writeTo(emitter);
        }
    }
}

