/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.ContentContainer;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.inline.InlineElement;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableElement
extends BlockElement {
    private LinkedList<LinkedList<Cell>> structure = new LinkedList();
    private final String title;

    public TableElement(String title) {
        this.title = title;
    }

    @Override
    public boolean append(DocbookElement elt) {
        return this.structure.getLast().getLast().append(elt);
    }

    public void doBeginTableRow(Map<String, String> parameters) {
        this.structure.addLast(new LinkedList());
    }

    public void doBeginTableHeadCell(Map<String, String> parameters) {
        this.structure.getLast().addLast(new Cell(true));
    }

    public void doEndTableHeadCell(Map<String, String> parameters) {
    }

    public void doBeginTableCell(Map<String, String> parameters) {
        this.structure.getLast().addLast(new Cell(false));
    }

    public void doEndTableCell(Map<String, String> parameters) {
    }

    public void doEndTableRow(Map<String, String> parameters) {
    }

    @Override
    public void writeTo(XMLEmitter xml) {
        LinkedList<Cell> row;
        LinkedList row2;
        ElementEmitter tableXML = xml.element("table");
        if (this.title != null) {
            ((XMLEmitter)tableXML).element("title").content(this.title);
        }
        int columnCount = 0;
        for (LinkedList linkedList : this.structure) {
            columnCount = Math.max(columnCount, linkedList.size());
        }
        LinkedList<LinkedList> head = new LinkedList<LinkedList>();
        Iterator iterator = this.structure.iterator();
        while (iterator.hasNext() && this.isHead(row2 = (LinkedList)iterator.next())) {
            head.addLast(row2);
            iterator.remove();
        }
        LinkedList<LinkedList<Cell>> linkedList = new LinkedList<LinkedList<Cell>>();
        ListIterator<LinkedList<Cell>> i2 = this.structure.listIterator(this.structure.size());
        while (i2.hasPrevious() && this.isHead(row = i2.previous())) {
            linkedList.addFirst(row);
            i2.remove();
        }
        ElementEmitter tgroup = ((XMLEmitter)tableXML).element("tgroup").withAttribute("cols", "" + columnCount);
        for (LinkedList a : Arrays.asList(head, this.structure, linkedList)) {
            if (a.isEmpty()) continue;
            ElementEmitter elementXML = a == head ? tgroup.element("thead") : (a == this.structure ? tgroup.element("tbody") : tgroup.element("tfoot"));
            for (LinkedList row4 : a) {
                ElementEmitter rowXML = elementXML.element("row");
                for (Cell cell : row4) {
                    cell.writeTo(rowXML.element("entry"));
                }
            }
        }
    }

    private boolean isHead(LinkedList<Cell> row) {
        for (Cell cell : row) {
            if (cell.head) continue;
            return false;
        }
        return true;
    }

    private static class Cell {
        private final boolean head;
        private ContentContainer content;
        private ElementContainer<InlineElement> inline;

        private Cell(boolean head) {
            this.head = head;
        }

        boolean append(DocbookElement elt) {
            if (elt instanceof InlineElement) {
                if (this.content != null) {
                    return this.content.append(elt);
                }
                if (this.inline == null) {
                    this.inline = new ElementContainer<InlineElement>(InlineElement.class);
                }
                return this.inline.append(elt);
            }
            if (this.inline == null) {
                if (this.content == null) {
                    this.content = new ContentContainer();
                }
                return this.content.append(elt);
            }
            this.content = new ContentContainer();
            for (InlineElement i : this.inline) {
                this.content.append(i);
            }
            this.inline = null;
            return this.content.append(elt);
        }

        void writeTo(XMLEmitter emitter) {
            if (this.content != null) {
                this.content.writeTo(emitter);
            } else if (this.inline != null) {
                this.inline.writeTo(emitter);
            }
        }
    }
}

