/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static Iterable<String> split(final String s) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int from = 0;

                    @Override
                    public boolean hasNext() {
                        return this.from <= s.length();
                    }

                    @Override
                    public String next() {
                        if (this.from > s.length()) {
                            throw new NoSuchElementException();
                        }
                        int to = s.indexOf(10, this.from);
                        if (to == -1) {
                            to = s.length();
                        }
                        String next = s.substring(this.from, to);
                        this.from = to + 1;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Reader read(URL url) throws IOException {
        return new InputStreamReader(url.openStream(), "UTF-8");
    }

    public static String read(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[256];
        int amount = reader.read(buffer);
        while (amount != -1) {
            writer.write(buffer, 0, amount);
            amount = reader.read(buffer);
        }
        return writer.toString();
    }

    public static byte[] load(URL url) throws IOException {
        return Utils.load(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] load(InputStream in) throws IOException {
        try {
            byte[] bytes = new byte[128];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int s = in.read(bytes);
            while (s != -1) {
                baos.write(bytes, 0, s);
                s = in.read(bytes);
            }
            byte[] byArray = bytes = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
    }
}

