/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model;

import org.wikbook.core.model.DocbookContext;
import org.wikbook.core.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocbookElement {
    DocbookContext context;

    public final void close() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        DocbookElement currentElt = this.context.currentMap.remove(this);
        if (currentElt != null) {
            if (!this.append(currentElt)) {
                throw new AssertionError((Object)("Could not append element " + currentElt.getClass().getName() + " to element " + this.getClass().getName()));
            }
            currentElt.close();
        }
    }

    private DocbookElement current(boolean remove) {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        DocbookElement currentElt = this.context.currentMap.get(this);
        if (currentElt != null) {
            DocbookElement nextElt = currentElt.current(remove);
            if (nextElt == null) {
                if (remove) {
                    this.context.currentMap.remove(this);
                    currentElt.context = null;
                }
            } else {
                currentElt = nextElt;
            }
        }
        return currentElt;
    }

    public final DocbookElement peek() {
        return this.current(false);
    }

    public final DocbookElement pop() {
        return this.current(true);
    }

    public final <E extends DocbookElement> E push(E elt) {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        if (elt.context != null) {
            throw new IllegalArgumentException("Already contextualized");
        }
        DocbookElement currentElt = this.context.currentMap.get(this);
        if (currentElt == null) {
            this.context.currentMap.put(this, elt);
            elt.context = this.context;
            return elt;
        }
        return currentElt.push(elt);
    }

    public final void merge() {
        this.merge(this.pop());
    }

    public final <E extends DocbookElement> E merge(E elt) {
        if (elt == null) {
            throw new NullPointerException();
        }
        if (this.context == null) {
            throw new IllegalStateException("No associated context with the element performing the merge");
        }
        if (elt.context != null) {
            throw new IllegalArgumentException("Already contextualized");
        }
        DocbookElement appendedElt = this.peek();
        if (appendedElt == null) {
            appendedElt = this;
        }
        if (!appendedElt.append(elt)) {
            throw new AssertionError((Object)("Could not append element " + elt.getClass().getName() + " to element " + this.getClass().getName()));
        }
        elt.context = this.context;
        return elt;
    }

    protected final DocbookContext getContext() {
        return this.context;
    }

    public boolean append(DocbookElement elt) {
        return false;
    }

    public void writeTo(XMLEmitter xml) {
        throw new UnsupportedOperationException("Class " + this.getClass().getName() + " does not implement writeTo");
    }
}

