/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block;

import java.util.EnumMap;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.ListItemElement;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;
import org.xwiki.rendering.listener.ListType;

public class ListElement
extends BlockElement {
    private static final EnumMap<ListType, String> listTypeMap = new EnumMap(ListType.class);
    private static final EnumMap<ListType, String> styleMap = new EnumMap(ListType.class);
    private final ListType type;
    private final ElementContainer<ListItemElement> items;
    private ListItemElement current;
    private final String style;

    public ListElement(ListType type, String style) {
        this.type = type;
        this.items = new ElementContainer<ListItemElement>(ListItemElement.class);
        this.style = style;
    }

    public ListType getType() {
        return this.type;
    }

    public void beginItem() {
        if (this.current != null) {
            throw new IllegalStateException();
        }
        this.current = new ListItemElement();
    }

    public void endItem() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.items.append(this.current);
        this.current = null;
    }

    public boolean append(DocbookElement elt) {
        if (elt instanceof ListElement) {
            this.current.append(elt);
            return true;
        }
        return this.current.append(elt);
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter listXML = xml.element(listTypeMap.get(this.type));
        if (this.style != null) {
            listXML.withAttribute(styleMap.get(this.type), this.style);
        }
        this.items.writeTo(listXML);
    }

    static {
        listTypeMap.put(ListType.BULLETED, "itemizedlist");
        listTypeMap.put(ListType.NUMBERED, "orderedlist");
        styleMap.put(ListType.BULLETED, "mark");
        styleMap.put(ListType.NUMBERED, "numeration");
    }
}

