/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.wikbook.core.ResourceType;
import org.wikbook.core.WikletContext;
import org.wikbook.core.codesource.CodeContext;
import org.wikbook.core.codesource.CodeProcessor;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.CalloutElement;
import org.wikbook.core.model.content.block.LanguageSyntax;
import org.wikbook.core.transform.XDOMTransformer;
import org.wikbook.core.wiki.WikiLoader;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.OutputFormat;
import org.wikbook.core.xml.XML;
import org.wikbook.core.xml.XMLEmitter;
import org.wikbook.text.Position;
import org.wikbook.text.TextArea;
import org.xml.sax.InputSource;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;

public class ProgramListingElement
extends BlockElement {
    private final ElementContainer<CalloutElement> callouts;
    private final LanguageSyntax languageSyntax;
    private final Integer indent;
    private final String content;
    private final WikletContext context;
    private final boolean highlightCode;
    private String listing;

    public ProgramListingElement(WikletContext context, LanguageSyntax languageSyntax, Integer indent, String content, boolean highlightCode) {
        this.context = context;
        this.languageSyntax = languageSyntax;
        this.indent = indent;
        this.content = content;
        this.highlightCode = highlightCode;
        this.callouts = new ElementContainer<CalloutElement>(CalloutElement.class);
    }

    public void process(XDOMTransformer _transformer) {
        String bilto;
        switch (this.languageSyntax) {
            case XML: {
                if (this.indent != null) {
                    try {
                        StringWriter writer = new StringWriter();
                        Transformer transformer = XML.createTransformer(new OutputFormat(this.indent, true));
                        String data = "<root>" + this.content + "</root>";
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        dbf.setIgnoringElementContentWhitespace(true);
                        dbf.setCoalescing(true);
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(new InputSource(new StringReader(data)));
                        XML.removeWhiteSpace(doc.getDocumentElement());
                        transformer.transform(new DOMSource(doc), new StreamResult(writer));
                        data = writer.toString();
                        int from = data.indexOf("<root>\n") + "<root>\n".length();
                        int to = data.lastIndexOf("\n</root>");
                        data = data.substring(from, to);
                        TextArea ta = new TextArea(data);
                        ta.trimLeft();
                        bilto = ta.getText();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        bilto = "Exception occured, see logs";
                    }
                    break;
                }
                bilto = this.content;
                break;
            }
            case JAVA: {
                CodeContextImpl ctx = new CodeContextImpl();
                new CodeProcessor().parse(this.content, ctx);
                for (Map.Entry callout : ctx.callouts.entrySet()) {
                    if (((Callout)callout.getValue()).text == null) continue;
                    CalloutElement calloutElt = new CalloutElement(((Callout)callout.getValue()).ids, ((Callout)callout.getValue()).text);
                    this.push(calloutElt);
                    WikiLoader loader = new WikiLoader(this.context);
                    XDOM dom = loader.load(new StringReader(((Callout)callout.getValue()).text), null);
                    dom.traverse((Listener)_transformer);
                    this.merge();
                }
                bilto = ctx.sb.toString();
                break;
            }
            default: {
                bilto = this.content;
            }
        }
        this.listing = bilto;
    }

    public boolean append(DocbookElement elt) {
        return this.callouts.append(elt);
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter programListingCoXML = xml.element("programlistingco");
        ElementEmitter areaspecXML = programListingCoXML.element("areaspec").withAttribute("units", "linecolumn");
        for (CalloutElement calloutElt : this.callouts) {
            for (Map.Entry<String, Position> target : calloutElt.getIds().entrySet()) {
                areaspecXML.element("area").withAttribute("id", target.getKey() + "-co").withAttribute("linkends", target.getKey()).withAttribute("coords", target.getValue().getLine() + 1 + " " + (target.getValue().getColumn() + 1));
            }
        }
        ElementEmitter programListingXML = programListingCoXML.element("programlisting");
        if (this.highlightCode && this.languageSyntax != LanguageSyntax.UNKNOWN) {
            programListingXML.withAttribute("language", this.languageSyntax.name().toLowerCase());
        }
        if (this.callouts.isNotEmpty()) {
            this.callouts.writeTo(programListingCoXML.element("calloutlist"));
        }
        programListingXML.content(this.listing, true);
    }

    private static class Callout {
        private String text;
        private final LinkedHashMap<String, Position> ids = new LinkedHashMap();

        private Callout() {
        }
    }

    private class CodeContextImpl
    implements CodeContext {
        private final StringBuilder sb = new StringBuilder();
        private final TreeMap<String, Callout> callouts = new TreeMap();
        private final Random random = new Random();

        private CodeContextImpl() {
        }

        public void writeContent(String content) {
            this.sb.append(content);
        }

        public void writeCallout(String index) {
            String coId = "" + Math.abs(this.random.nextLong());
            TextArea ta = new TextArea(this.sb.toString());
            Position pos = ta.position(this.sb.length());
            Callout callout = this.callouts.get(index);
            if (callout == null) {
                callout = new Callout();
                this.callouts.put(index, callout);
            }
            this.writeContent(" ");
            callout.ids.put(coId, pos);
        }

        public void setCallout(String index, String text) {
            Callout callout = this.callouts.get(index);
            if (callout == null) {
                callout = new Callout();
                this.callouts.put(index, callout);
            }
            callout.text = text;
        }

        public InputStream resolveResources(String id) throws IOException {
            List<URL> list = ProgramListingElement.this.context.resolveResources(ResourceType.JAVA, id);
            if (list.size() > 0) {
                return list.get(0).openStream();
            }
            return null;
        }
    }
}

