/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block.table;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.table.TableCellElement;
import org.wikbook.core.model.content.block.table.TableRowElement;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

public class TableElement
extends BlockElement {
    private ElementContainer<TableRowElement> structure = new ElementContainer<TableRowElement>(TableRowElement.class);
    private final String title;

    public TableElement(String title) {
        this.title = title;
    }

    public boolean append(DocbookElement elt) {
        return this.structure.append(elt);
    }

    public void writeTo(XMLEmitter xml) {
        TableRowElement row;
        TableRowElement row2;
        ElementEmitter tableXML = xml.element("table");
        if (this.title != null) {
            ((XMLEmitter)tableXML).element("title").content(this.title);
        }
        int columnCount = 0;
        for (TableRowElement row3 : this.structure) {
            columnCount = Math.max(columnCount, row3.cells.getSize());
        }
        LinkedList<TableRowElement> head = new LinkedList<TableRowElement>();
        Iterator<TableRowElement> i = this.structure.iterator();
        while (i.hasNext() && (row2 = i.next()).isHead()) {
            head.addLast(row2);
            i.remove();
        }
        LinkedList<TableRowElement> foot = new LinkedList<TableRowElement>();
        Iterator<TableRowElement> i2 = this.structure.reverseIterator();
        while (i2.hasNext() && (row = i2.next()).isHead()) {
            foot.addFirst(row);
            i2.remove();
        }
        LinkedList<TableRowElement> body = new LinkedList<TableRowElement>();
        for (TableRowElement row4 : this.structure) {
            body.add(row4);
        }
        ElementEmitter tgroup = ((XMLEmitter)tableXML).element("tgroup").withAttribute("cols", "" + columnCount);
        for (LinkedList a : Arrays.asList(head, body, foot)) {
            if (a.isEmpty()) continue;
            ElementEmitter elementXML = a == head ? tgroup.element("thead") : (a == body ? tgroup.element("tbody") : tgroup.element("tfoot"));
            for (TableRowElement row5 : a) {
                ElementEmitter rowXML = elementXML.element("row");
                if (row5.getVAlign() != null) {
                    rowXML.withAttribute("valign", row5.getVAlign().toString().toLowerCase());
                }
                for (TableCellElement cell : row5.cells) {
                    ElementEmitter entryXML = rowXML.element("entry");
                    if (cell.getAlign() != null) {
                        entryXML.withAttribute("align", cell.getAlign().toString().toLowerCase());
                    }
                    if (cell.getVAlign() != null) {
                        entryXML.withAttribute("valign", cell.getVAlign().toString().toLowerCase());
                    }
                    cell.writeTo(entryXML);
                }
            }
        }
    }
}

