/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.structural;

import org.w3c.dom.DocumentFragment;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.ContentElement;
import org.wikbook.core.model.content.ContentElementContainer;
import org.wikbook.core.model.structural.ComponentElement;
import org.wikbook.core.model.structural.StructuralElement;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

public class BookElement
extends StructuralElement {
    private final ElementContainer<ComponentElement> chapters = new ElementContainer<ComponentElement>(ComponentElement.class);
    private ContentElementContainer preface = new ContentElementContainer();
    private String prefaceTitle = "Preface";
    private boolean omitRootNode = false;
    private DocumentFragment beforeBodyXML;
    private DocumentFragment afterBodyXML;

    public String getPrefaceTitle() {
        return this.prefaceTitle;
    }

    public void setPrefaceTitle(String prefaceTitle) {
        this.prefaceTitle = prefaceTitle;
    }

    public boolean getOmitRootNode() {
        return this.omitRootNode;
    }

    public void setOmitRootNode(boolean omitRootNode) {
        this.omitRootNode = omitRootNode;
    }

    public DocumentFragment getBeforeBodyXML() {
        return this.beforeBodyXML;
    }

    public void setBeforeBodyXML(DocumentFragment beforeBodyXML) {
        this.beforeBodyXML = beforeBodyXML;
    }

    public DocumentFragment getAfterBodyXML() {
        return this.afterBodyXML;
    }

    public void setAfterBodyXML(DocumentFragment afterBodyXML) {
        this.afterBodyXML = afterBodyXML;
    }

    public boolean append(DocbookElement elt) {
        if (elt instanceof ContentElement) {
            return this.preface.append(elt);
        }
        if (elt instanceof ComponentElement) {
            return this.chapters.append(elt);
        }
        return false;
    }

    public void writeTo(XMLEmitter xml) {
        if (!this.omitRootNode) {
            xml = xml.element("book");
        }
        if (this.beforeBodyXML != null) {
            xml.append(this.beforeBodyXML);
        }
        if (this.preface.isNotEmpty()) {
            ElementEmitter prefaceXML = xml.element("preface");
            if (this.prefaceTitle != null) {
                prefaceXML.element("title").content("Preface");
            }
            this.preface.writeTo(prefaceXML);
        }
        this.chapters.writeTo(xml);
        if (this.afterBodyXML != null) {
            xml.append(this.afterBodyXML);
        }
    }
}

