/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.render.docbook.content.block;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wikbook.core.model.content.block.ImageElement;
import org.wikbook.core.render.docbook.ElementTransformer;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageTransformer
extends ElementTransformer<ImageElement> {
    private static final Map<String, String> formats = new HashMap<String, String>();
    private static final List<String> outputs = Collections.unmodifiableList(Arrays.asList("fo", "html"));
    private static final Set<String> imageDataAttributes = new HashSet<String>();

    @Override
    public void write(ImageElement element, XMLEmitter emitter) {
        String format;
        String extension = "";
        int lastDot = element.getName().lastIndexOf(46);
        if (lastDot > -1) {
            extension = element.getName().substring(lastDot + 1).toLowerCase();
        }
        if ((format = formats.get(extension)) != null) {
            ElementEmitter mediaObjectXML;
            String title = element.getParameters().get("title");
            if (title != null) {
                ElementEmitter figureXML = emitter.element("figure");
                figureXML.element("title").content(title);
                mediaObjectXML = figureXML.element("mediaobject");
            } else {
                mediaObjectXML = emitter.element("inlinemediaobject");
            }
            for (String output : outputs) {
                ElementEmitter imageDataXML = mediaObjectXML.element("imageobject").withAttribute("role", output).element("imagedata").withAttribute("fileref", element.getName()).withAttribute("format", format);
                for (Map.Entry<String, String> entry : element.getParameters().entrySet()) {
                    String attrelementName;
                    String prefix;
                    String key = entry.getKey();
                    int colonIndex = key.indexOf(":");
                    String string = prefix = colonIndex != -1 ? key.substring(0, colonIndex + 1) : "";
                    if (prefix.length() != 0 && !prefix.equals(output + ":") || !imageDataAttributes.contains(attrelementName = key.substring(prefix.length()))) continue;
                    imageDataXML.withAttribute(attrelementName, entry.getValue());
                }
            }
        }
    }

    static {
        formats.put("png", "PNG");
        formats.put("gif", "GIF");
        formats.put("jpg", "JPG");
        formats.put("jpeg", "JPG");
        formats.put("tiff", "TIFF");
        imageDataAttributes.add("align");
        imageDataAttributes.add("valign");
        imageDataAttributes.add("width");
        imageDataAttributes.add("depth");
        imageDataAttributes.add("scale");
        imageDataAttributes.add("scalefit");
        imageDataAttributes.add("contentwidth");
        imageDataAttributes.add("contentdepth");
    }
}

