/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.w3c.dom.Element;
import org.wikbook.core.Align;
import org.wikbook.core.ResourceType;
import org.wikbook.core.VAlign;
import org.wikbook.core.model.DocbookBuilderContext;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.DocbookElementContext;
import org.wikbook.core.model.content.Image;
import org.wikbook.core.model.content.block.AdmonitionElement;
import org.wikbook.core.model.content.block.AdmonitionKind;
import org.wikbook.core.model.content.block.BlockQuotationElement;
import org.wikbook.core.model.content.block.DOMElement;
import org.wikbook.core.model.content.block.ExampleElement;
import org.wikbook.core.model.content.block.GroupElement;
import org.wikbook.core.model.content.block.ImageElement;
import org.wikbook.core.model.content.block.LanguageSyntax;
import org.wikbook.core.model.content.block.ListElement;
import org.wikbook.core.model.content.block.ListItemElement;
import org.wikbook.core.model.content.block.ListKind;
import org.wikbook.core.model.content.block.ParagraphElement;
import org.wikbook.core.model.content.block.ProgramListingElement;
import org.wikbook.core.model.content.block.ScreenElement;
import org.wikbook.core.model.content.block.list.TermElement;
import org.wikbook.core.model.content.block.list.VariableListElement;
import org.wikbook.core.model.content.block.table.TableCellElement;
import org.wikbook.core.model.content.block.table.TableElement;
import org.wikbook.core.model.content.block.table.TableRowElement;
import org.wikbook.core.model.content.inline.AnchorElement;
import org.wikbook.core.model.content.inline.FormatElement;
import org.wikbook.core.model.content.inline.InlineImageElement;
import org.wikbook.core.model.content.inline.LinkElement;
import org.wikbook.core.model.content.inline.LinkType;
import org.wikbook.core.model.content.inline.TextElement;
import org.wikbook.core.model.content.inline.TextFormat;
import org.wikbook.core.model.structural.ComponentElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocbookBuilder {
    private final DocbookBuilderContext context;
    private DocbookElement root;
    private final DocbookElementContext rootContext = new DocbookElementContext(){

        public URL resolveResource(ResourceType type, String id) throws IOException {
            return DocbookBuilder.this.context.resolveResource(type, id);
        }

        public void build(Reader reader, DocbookElement element) {
            new DocbookBuilder(DocbookBuilder.this.context, element).build(reader, null);
        }
    };

    public DocbookBuilder(DocbookBuilderContext context, DocbookElement root) {
        if (context == null) {
            throw new NullPointerException("No null context accepted");
        }
        this.context = context;
        this.root = root;
    }

    public void build(Reader reader, String syntaxId) {
        this.root.context = this.rootContext;
        this.context.build(reader, syntaxId, this);
        this.root.context = null;
    }

    public boolean isInlineContext() {
        DocbookElement elt = this.root.peek();
        return elt != null && elt.hasInlineAppended();
    }

    public DocbookElement getRoot() {
        return this.root;
    }

    public void beginParagraph() {
        this.root.push(new ParagraphElement());
    }

    public void endParagraph() {
        this.root.merge();
    }

    public void beginSection() {
        this.root.push(new ComponentElement());
    }

    public void endSection() {
        this.root.merge();
    }

    public void beginHeader() {
        ((ComponentElement)this.root.peek()).beginTitle();
    }

    public void endHeader() {
        ((ComponentElement)this.root.peek()).endTitle();
    }

    public void onText(String text) {
        this.root.merge(new TextElement(text));
    }

    public void beginFormat(TextFormat format) {
        this.root.push(new FormatElement(format));
    }

    public void endFormat(TextFormat format) {
        this.root.merge();
    }

    public void beginList(ListKind listKind, String style) {
        this.root.push(new ListElement(listKind, style));
    }

    public void endList(ListKind listKind, String style) {
        this.root.merge();
    }

    public void beginListItem() {
        this.root.push(new ListItemElement());
    }

    public void endListItem() {
        this.root.merge();
    }

    public void beginAdmonition(AdmonitionKind admonition) {
        if (this.isInlineContext()) {
            this.context.onValidationError("No admonition " + (Object)((Object)admonition) + " allowed inside");
        } else {
            AdmonitionElement admonitionElt = new AdmonitionElement(admonition);
            this.root.push(admonitionElt);
        }
    }

    public void endAdmonition(AdmonitionKind admonition) {
        if (this.isInlineContext()) {
            this.context.onValidationError("No admonition " + (Object)((Object)admonition) + " allowed inside");
        } else {
            this.root.merge();
        }
    }

    public void beginExample(String title) {
        this.root.push(new ExampleElement(title));
    }

    public void endExample(String title) {
        this.root.merge();
    }

    public void beginLink(LinkType linkType, String ref) {
        this.root.push(new LinkElement(linkType, ref));
    }

    public void endLink(LinkType linkType, String ref) {
        this.root.merge();
    }

    public void beginScreen() {
        ScreenElement screenElt = new ScreenElement();
        this.root.push(screenElt);
    }

    public void endScreen() {
        this.root.merge();
    }

    public void beginTable(String title) {
        this.root.push(new TableElement(title));
    }

    public void endTable(String title) {
        this.root.merge();
    }

    public void beginTableRow(Map<String, String> parameters) {
        String valignParam = parameters.get("valign");
        VAlign valign = null;
        if (valignParam != null) {
            try {
                valign = VAlign.valueOf(valignParam.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.context.onValidationError("Wrong valign parameter value " + valignParam);
            }
        }
        this.root.push(new TableRowElement(valign));
    }

    public void endTableRow(Map<String, String> parameters) {
        this.root.merge();
    }

    public void beginTableCell(Map<String, String> parameters) {
        String alignParam = parameters.get("align");
        Align align = null;
        if (alignParam != null) {
            try {
                align = Align.valueOf(alignParam.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.context.onValidationError("Wrong align parameter value " + alignParam);
            }
        }
        String valignParam = parameters.get("valign");
        VAlign valign = null;
        if (valignParam != null) {
            try {
                valign = VAlign.valueOf(valignParam.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.context.onValidationError("Wrong valign parameter value " + valignParam);
            }
        }
        this.root.push(new TableCellElement(false, align, valign));
    }

    public void endTableCell(Map<String, String> parameters) {
        this.root.merge();
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        String alignParam = parameters.get("align");
        Align align = null;
        if (alignParam != null) {
            try {
                align = Align.valueOf(alignParam.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.context.onValidationError("Wrong align parameter value " + alignParam);
            }
        }
        String valignParam = parameters.get("valign");
        VAlign valign = null;
        if (valignParam != null) {
            try {
                valign = VAlign.valueOf(valignParam.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.context.onValidationError("Wrong valign parameter value " + valignParam);
            }
        }
        this.root.push(new TableCellElement(true, align, valign));
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.root.merge();
    }

    public void beginDefinitionList(String title) {
        this.root.push(new VariableListElement(title));
    }

    public void endDefinitionList(String title) {
        this.root.merge();
    }

    public void beginDefinitionTerm() {
        this.root.push(new TermElement());
    }

    public void endDefinitionTerm() {
        this.root.merge();
    }

    public void beginDefinitionDescription() {
        this.root.push(new ListItemElement());
    }

    public void endDefinitionDescription() {
        this.root.merge();
    }

    public void beginQuotation() {
        this.root.push(new BlockQuotationElement());
    }

    public void endQuotation() {
        this.root.merge();
    }

    public void beginGroup() {
        this.root.push(new GroupElement());
    }

    public void endGroup() {
        this.root.merge();
    }

    public void onVerbatim(String text) {
        this.root.merge(new TextElement(text));
    }

    public void onImage(String imageName, Map<String, String> parameters) {
        if (this.isInlineContext()) {
            this.root.merge(new InlineImageElement(new Image(imageName, parameters)));
        } else {
            this.root.merge(new ImageElement(new Image(imageName, parameters)));
        }
    }

    public void onCode(LanguageSyntax language, Integer indent, String content) {
        ProgramListingElement programListingElt = this.root.push(new ProgramListingElement(this.context, language, indent, content, this.context.getHighlightCode()));
        programListingElt.process();
        this.root.merge();
    }

    public void onAnchor(String anchor) {
        this.root.merge(new AnchorElement(anchor));
    }

    public void onDocbook(Element docbookElt) {
        this.root.merge(new DOMElement(docbookElt));
    }
}

