/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.render.docbook.content.block;

import java.util.Map;
import org.wikbook.core.model.content.block.CalloutElement;
import org.wikbook.core.model.content.block.LanguageSyntax;
import org.wikbook.core.model.content.block.ProgramListingElement;
import org.wikbook.core.render.docbook.ElementTransformer;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;
import org.wikbook.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramListingTransformer
extends ElementTransformer<ProgramListingElement> {
    @Override
    public void write(ProgramListingElement element, XMLEmitter emitter) {
        ElementEmitter programListingCoXML = emitter.element("programlistingco");
        ElementEmitter areaspecXML = programListingCoXML.element("areaspec").withAttribute("units", "linecolumn");
        for (CalloutElement calloutElt : element.getCallouts()) {
            for (Map.Entry<String, Position> target : calloutElt.getIds().entrySet()) {
                areaspecXML.element("area").withAttribute("id", target.getKey() + "-co").withAttribute("linkends", target.getKey()).withAttribute("coords", target.getValue().getLine() + 1 + " " + (target.getValue().getColumn() + 1));
            }
        }
        ElementEmitter programListingXML = programListingCoXML.element("programlisting");
        if (element.isHighlightCode() && element.getLanguageSyntax() != LanguageSyntax.UNKNOWN) {
            programListingXML.withAttribute("language", element.getLanguageSyntax().name().toLowerCase());
        }
        if (element.getCallouts().isNotEmpty()) {
            this.write(element.getCallouts(), false, programListingCoXML.element("calloutlist"));
        }
        programListingXML.content(element.getListing(), true);
    }
}

