/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.model.content.block;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.wikbook.codesource.CodeSourceBuilder;
import org.wikbook.codesource.TypeSource;
import org.wikbook.model.content.block.BlockElement;
import org.wikbook.model.content.block.CodeLanguage;
import org.wikbook.model.content.block.JavaCodeLink;
import org.wikbook.text.TextArea;
import org.wikbook.xml.ElementEmitter;
import org.wikbook.xml.OutputFormat;
import org.wikbook.xml.XML;
import org.wikbook.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramListingElement
extends BlockElement {
    private static final String WHITE_NON_CR = "[ \t\\x0B\f\r]";
    private static final Pattern LINE_COMMENT = Pattern.compile("//\\s*<([0-9]+)>[ \t\\x0B\f\r]*(=)?([^\n]*)");
    private static final Pattern JAVA_INCLUDE_PATTERN = Pattern.compile("\\{@(include|javadoc)\\s+([^\\s]+)\\s*\\}");
    private static final Random random = new Random();
    private final String language;
    private final Integer indent;
    private final String content;

    public ProgramListingElement(String language, Integer indent, String content) {
        this.language = language;
        this.indent = indent;
        this.content = content;
    }

    @Override
    public void writeTo(XMLEmitter xml) {
        ElementEmitter programListingCoXML = xml.element("programlistingco");
        ElementEmitter programListingXML = programListingCoXML.element("programlisting");
        CodeLanguage codeLanguage = CodeLanguage.UNKNOWN;
        if (this.language != null) {
            if ("java".equalsIgnoreCase(this.language)) {
                codeLanguage = CodeLanguage.JAVA;
            } else if ("xml".equalsIgnoreCase(this.language)) {
                codeLanguage = CodeLanguage.XML;
            }
        }
        String bilto = this.content;
        switch (codeLanguage) {
            case XML: {
                if (this.indent != null) {
                    try {
                        Transformer transformer = XML.createTransformer(new OutputFormat(this.indent, true));
                        StringWriter writer = new StringWriter();
                        transformer.transform(new StreamSource(new StringReader(this.content)), new StreamResult(writer));
                        bilto = writer.toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        bilto = "Exception occured, see logs";
                    }
                }
                programListingXML.content(bilto, true);
                break;
            }
            case UNKNOWN: {
                programListingXML.content(bilto, true);
                break;
            }
            case JAVA: {
                TreeMap<String, Callout> callouts = new TreeMap<String, Callout>();
                this.parse(bilto, programListingXML, callouts);
                if (callouts.size() <= 0) break;
                ElementEmitter calloutListXML = programListingCoXML.element("calloutlist");
                for (Map.Entry<String, Callout> callout : callouts.entrySet()) {
                    if (callout.getValue().text == null) continue;
                    StringBuffer sb = new StringBuffer();
                    for (String coId : callout.getValue().ids) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(coId);
                    }
                    calloutListXML.element("callout").withAttribute("arearefs", sb.toString()).element("para").content(callout.getValue().text, true);
                }
                break;
            }
        }
    }

    private void printJavaSource(String s, XMLEmitter programListingElt, Map<String, Callout> callouts) {
        TextArea ta = new TextArea(s);
        Random random = new Random();
        Matcher matcher = LINE_COMMENT.matcher(s);
        int prev = 0;
        while (matcher.find()) {
            String text;
            String id = matcher.group(1);
            programListingElt.content(ta.clip(ta.position(prev), ta.position(matcher.start())), true);
            Callout callout = callouts.get(id);
            if (callout == null) {
                callout = new Callout();
                callouts.put(id, callout);
            }
            if (!"=".equals(matcher.group(2))) {
                String coId = "" + Math.abs(random.nextLong());
                callout.ids.add(coId);
                programListingElt.element("co").withAttribute("id", coId);
            }
            if (!(text = matcher.group(3)).matches("\\s*")) {
                callout.text = text.trim();
            }
            prev = matcher.end();
        }
        programListingElt.content(ta.clip(ta.position(prev)), true);
    }

    private void parse(String s, XMLEmitter programListingElt, Map<String, Callout> callouts) {
        int prev = 0;
        Matcher matcher = JAVA_INCLUDE_PATTERN.matcher(s);
        while (matcher.find()) {
            JavaCodeLink l = JavaCodeLink.parse(matcher.group(2));
            CodeSourceBuilder builder = new CodeSourceBuilder();
            TypeSource typeSource = builder.buildClass(l.getFQN());
            Object source = l.getMember() != null ? typeSource.findMember(l.getMember()) : typeSource;
            this.printJavaSource(s.substring(prev, matcher.start()), programListingElt, callouts);
            if ("include".equals(matcher.group(1))) {
                this.printJavaSource(source.getClip(), programListingElt, callouts);
            } else if ("javadoc".equals(matcher.group(1)) && source.getJavaDoc() != null) {
                String javadoc = source.getJavaDoc();
                programListingElt.content(javadoc, true);
            }
            prev = matcher.end();
        }
        this.printJavaSource(s.substring(prev), programListingElt, callouts);
    }

    private static class Callout {
        private String text;
        private final LinkedList<String> ids = new LinkedList();

        private Callout() {
        }
    }
}

