/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.render.docbook.content.block;

import java.util.EnumMap;
import org.wikbook.core.model.content.block.ListElement;
import org.wikbook.core.model.content.block.ListKind;
import org.wikbook.core.render.docbook.ElementTransformer;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTransformer
extends ElementTransformer<ListElement> {
    private static final EnumMap<ListKind, String> ListKindMap = new EnumMap(ListKind.class);
    private static final EnumMap<ListKind, String> styleMap = new EnumMap(ListKind.class);

    @Override
    public void write(ListElement element, XMLEmitter emitter) {
        ElementEmitter listXML = emitter.element(ListKindMap.get((Object)element.getKind()));
        if (element.getStyle() != null) {
            listXML.withAttribute(styleMap.get((Object)element.getKind()), element.getStyle());
        }
        this.write(element.getItems(), false, listXML);
    }

    static {
        ListKindMap.put(ListKind.BULLETED, "itemizedlist");
        ListKindMap.put(ListKind.NUMBERED, "orderedlist");
        styleMap.put(ListKind.BULLETED, "mark");
        styleMap.put(ListKind.NUMBERED, "numeration");
    }
}

