/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.render.docbook.content.inline;

import org.wikbook.core.model.content.inline.LinkElement;
import org.wikbook.core.render.docbook.ElementTransformer;
import org.wikbook.core.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkTransformer
extends ElementTransformer<LinkElement> {
    @Override
    public void write(LinkElement element, XMLEmitter emitter) {
        switch (element.getLinkType()) {
            case ANCHOR: {
                if (element.getContainer().isNotEmpty()) {
                    this.write(element.getContainer(), false, emitter.element("link").withAttribute("linkend", element.getRef()));
                    break;
                }
                emitter.element("xref").withAttribute("linkend", element.getRef());
                break;
            }
            case URL: {
                if (element.getRef().startsWith("mailto:")) {
                    emitter.element("email").content(element.getRef().substring("mailto:".length()));
                    break;
                }
                if (element.getContainer().isNotEmpty()) {
                    this.write(element.getContainer(), false, emitter.element("ulink").withAttribute("url", element.getRef()));
                    break;
                }
                emitter.element("ulink").withAttribute("url", element.getRef()).content(element.getRef());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

