/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.model.content.block;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wikbook.model.content.block.BlockElement;
import org.wikbook.xml.ElementEmitter;
import org.wikbook.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageElement
extends BlockElement {
    private static final Map<String, String> formats = new HashMap<String, String>();
    private static final List<String> outputs = Collections.unmodifiableList(Arrays.asList("fo", "html"));
    private static final Set<String> imageDataAttributes = new HashSet<String>();
    private final String name;
    private final Map<String, String> parameters;

    public ImageElement(String name, Map<String, String> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    @Override
    public void writeTo(XMLEmitter xml) {
        String format;
        String extension = "";
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot > -1) {
            extension = this.name.substring(lastDot + 1).toLowerCase();
        }
        if ((format = formats.get(extension)) != null) {
            ElementEmitter figureXML;
            String title = this.parameters.get("title");
            if (title != null) {
                figureXML = xml.element("figure");
                figureXML.element("title").content(title);
            } else {
                figureXML = xml.element("informalfigure");
            }
            ElementEmitter mediaObjectXML = figureXML.element("mediaobject");
            for (String output : outputs) {
                ElementEmitter imageDataXML = mediaObjectXML.element("imageobject").withAttribute("role", output).element("imagedata").withAttribute("fileref", this.name).withAttribute("format", format);
                for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                    String attrName;
                    String prefix;
                    String key = entry.getKey();
                    int colonIndex = key.indexOf(":");
                    String string = prefix = colonIndex != -1 ? key.substring(0, colonIndex + 1) : "";
                    if (prefix.length() != 0 && !prefix.equals(output + ":") || !imageDataAttributes.contains(attrName = key.substring(prefix.length()))) continue;
                    imageDataXML.withAttribute(attrName, entry.getValue());
                }
            }
        }
    }

    static {
        formats.put("png", "PNG");
        formats.put("gif", "GIF");
        formats.put("jpg", "JPG");
        formats.put("jpeg", "JPG");
        formats.put("tiff", "TIFF");
        imageDataAttributes.add("align");
        imageDataAttributes.add("valign");
        imageDataAttributes.add("width");
        imageDataAttributes.add("depth");
        imageDataAttributes.add("scale");
        imageDataAttributes.add("scalefit");
        imageDataAttributes.add("contentwidth");
        imageDataAttributes.add("contentdepth");
    }
}

