/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.wikbook.core.ResourceType;
import org.wikbook.core.WikletContext;
import org.wikbook.core.codesource.CodeContext;
import org.wikbook.core.codesource.CodeProcessor;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.CodeLanguage;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.OutputFormat;
import org.wikbook.core.xml.XML;
import org.wikbook.core.xml.XMLEmitter;

public class ProgramListingElement
extends BlockElement {
    private final String language;
    private final Integer indent;
    private final String content;
    private final WikletContext context;

    public ProgramListingElement(WikletContext context, String language, Integer indent, String content) {
        this.context = context;
        this.language = language;
        this.indent = indent;
        this.content = content;
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter programListingCoXML = xml.element("programlistingco");
        ElementEmitter programListingXML = programListingCoXML.element("programlisting");
        CodeLanguage codeLanguage = CodeLanguage.UNKNOWN;
        if (this.language != null) {
            if ("java".equalsIgnoreCase(this.language)) {
                codeLanguage = CodeLanguage.JAVA;
            } else if ("xml".equalsIgnoreCase(this.language)) {
                codeLanguage = CodeLanguage.XML;
            }
        }
        String bilto = this.content;
        switch (codeLanguage) {
            case XML: {
                if (this.indent != null) {
                    try {
                        Transformer transformer = XML.createTransformer(new OutputFormat(this.indent, true));
                        StringWriter writer = new StringWriter();
                        transformer.transform(new StreamSource(new StringReader(this.content)), new StreamResult(writer));
                        bilto = writer.toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        bilto = "Exception occured, see logs";
                    }
                }
                programListingXML.content(bilto, true);
                break;
            }
            case UNKNOWN: {
                programListingXML.content(bilto, true);
                break;
            }
            case JAVA: {
                CodeContextImpl ctx = new CodeContextImpl(programListingXML);
                new CodeProcessor().parse(bilto, ctx);
                if (ctx.callouts.size() <= 0) break;
                ElementEmitter calloutListXML = programListingCoXML.element("calloutlist");
                for (Map.Entry callout : ctx.callouts.entrySet()) {
                    if (((Callout)callout.getValue()).text == null) continue;
                    StringBuffer sb = new StringBuffer();
                    for (String coId : ((Callout)callout.getValue()).ids) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(coId);
                    }
                    calloutListXML.element("callout").withAttribute("arearefs", sb.toString()).element("para").content(((Callout)callout.getValue()).text, true);
                }
                break;
            }
        }
    }

    private static class Callout {
        private String text;
        private final LinkedList<String> ids = new LinkedList();

        private Callout() {
        }
    }

    private class CodeContextImpl
    implements CodeContext {
        private final XMLEmitter programListingElt;
        private final TreeMap<String, Callout> callouts = new TreeMap();
        private final Random random = new Random();

        private CodeContextImpl(XMLEmitter programListingElt) {
            this.programListingElt = programListingElt;
        }

        public void writeContent(String content) {
            this.programListingElt.content(content, true);
        }

        public void writeCallout(String id) {
            String coId = "" + Math.abs(this.random.nextLong());
            this.programListingElt.element("co").withAttribute("id", coId);
            Callout callout = this.callouts.get(id);
            if (callout == null) {
                callout = new Callout();
                this.callouts.put(id, callout);
            }
            callout.ids.addLast(coId);
        }

        public void setCallout(String id, String text) {
            Callout callout = this.callouts.get(id);
            if (callout == null) {
                callout = new Callout();
                this.callouts.put(id, callout);
            }
            callout.text = text;
        }

        public InputStream resolveResources(String id) throws IOException {
            List<URL> list = ProgramListingElement.this.context.resolveResources(ResourceType.JAVA, id);
            if (list.size() > 0) {
                return list.get(0).openStream();
            }
            return null;
        }
    }
}

