/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.structural;

import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.ContentContainer;
import org.wikbook.core.model.content.ContentElement;
import org.wikbook.core.model.structural.ComponentElement;
import org.wikbook.core.model.structural.StructuralElement;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

public class BookElement
extends StructuralElement {
    private final ElementContainer<ComponentElement> chapters = new ElementContainer<ComponentElement>(ComponentElement.class);
    private ContentContainer preface = new ContentContainer();
    private String prefaceTitle = "Preface";
    private boolean omitRootNode = false;

    public String getPrefaceTitle() {
        return this.prefaceTitle;
    }

    public void setPrefaceTitle(String prefaceTitle) {
        this.prefaceTitle = prefaceTitle;
    }

    public boolean getOmitRootNode() {
        return this.omitRootNode;
    }

    public void setOmitRootNode(boolean omitRootNode) {
        this.omitRootNode = omitRootNode;
    }

    public boolean append(DocbookElement elt) {
        if (elt instanceof ContentElement) {
            return this.preface.append(elt);
        }
        if (elt instanceof ComponentElement) {
            return this.chapters.append(elt);
        }
        return false;
    }

    public void writeTo(XMLEmitter xml) {
        if (!this.omitRootNode) {
            xml = xml.element("book");
        }
        if (this.preface.isNotEmpty()) {
            ElementEmitter prefaceXML = xml.element("preface");
            if (this.prefaceTitle != null) {
                prefaceXML.element("title").content("Preface");
            }
            this.preface.writeTo(prefaceXML);
        }
        this.chapters.writeTo(xml);
    }
}

