/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.wikbook.Person;
import org.wikbook.ResourceType;
import org.wikbook.WikletContext;
import org.wikbook.WikletConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikBookMojo
extends AbstractMojo
implements WikletContext {
    private File sourceDirectory;
    private String sourceFileName;
    private String syntaxId;
    private File destinationDirectory;
    private String destinationFileName;
    protected MavenSession session;
    protected List pluginArtifacts;

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public File getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void setDestinationDirectory(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public void setDestinationFileName(String destinationFileName) {
        this.destinationFileName = destinationFileName;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        WikletConverter converter;
        File src = new File(this.sourceDirectory, this.sourceFileName);
        if (!src.exists()) {
            throw new MojoFailureException("Source file " + src.getAbsolutePath() + " does not exist");
        }
        if (!src.isFile()) {
            throw new MojoFailureException("Source file " + src.getAbsolutePath() + " is not a file");
        }
        if (this.destinationDirectory.exists()) {
            if (!this.destinationDirectory.isDirectory()) {
                throw new MojoFailureException("Destination directory " + this.destinationDirectory.getAbsolutePath() + " is not a directory");
            }
        } else if (!this.destinationDirectory.mkdirs()) {
            throw new MojoFailureException("Could not create destination directory " + this.destinationDirectory.getAbsolutePath());
        }
        try {
            converter = new WikletConverter((WikletContext)this);
        }
        catch (Exception e) {
            throw new MojoFailureException("", (Throwable)e);
        }
        converter.setEmitDTD(true);
        converter.setSyntaxId(this.syntaxId);
        File destination = new File(this.destinationDirectory, this.destinationFileName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        converter.convert(this.sourceFileName, (Result)result);
        try {
            FileOutputStream out = new FileOutputStream(destination);
            out.write(baos.toByteArray());
            out.close();
        }
        catch (IOException e) {
            MojoFailureException mfe = new MojoFailureException("Could not create destination file");
            mfe.initCause((Throwable)e);
            throw mfe;
        }
    }

    public List<Person> findPersonsByRole(String roleName) {
        ArrayList<Person> ps = new ArrayList<Person>();
        MavenProject project = this.session.getCurrentProject();
        for (Developer developer : project.getDevelopers()) {
            if (!developer.getRoles().contains(roleName)) continue;
            String firstName = null;
            String lastName = null;
            if (developer.getName() != null) {
                String[] names = developer.getName().trim().split("\\s+");
                if (names.length > 0) {
                    firstName = names[0];
                }
                if (names.length > 1) {
                    firstName = names[1];
                }
            }
            Person p = new Person(firstName, lastName, developer.getEmail(), developer.getOrganization(), new HashSet(developer.getRoles()));
            ps.add(p);
        }
        return ps;
    }

    public List<URL> resolveResources(ResourceType type, String id) throws IOException {
        switch (type) {
            case WIKI_SOURCE: {
                File f = new File(this.sourceDirectory, id);
                if (!f.exists() || !f.isFile()) break;
                return Arrays.asList(f.toURI().toURL());
            }
            case CATALOG: {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Artifact artifact : this.pluginArtifacts) {
                    urls.add(artifact.getFile().toURI().toURL());
                }
                try {
                    for (String elt : this.session.getCurrentProject().getCompileClasspathElements()) {
                        File eltFile = new File(elt);
                        urls.add(eltFile.toURI().toURL());
                    }
                }
                catch (DependencyResolutionRequiredException e) {
                    e.printStackTrace();
                }
                URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
                Enumeration<URL> found = cl.getResources(id);
                ArrayList<URL> bilto = new ArrayList<URL>();
                while (found.hasMoreElements()) {
                    bilto.add(found.nextElement());
                }
                return bilto;
            }
        }
        return null;
    }

    public URL resolveResource(ResourceType type, String id) throws IOException {
        List<URL> found = this.resolveResources(type, id);
        return found.isEmpty() ? null : found.get(0);
    }

    public String getProperty(String propertyName) {
        Properties properties = this.session.getCurrentProject().getProperties();
        return properties.getProperty(propertyName);
    }
}

