/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.wikbook.core.Person;
import org.wikbook.core.ResourceType;
import org.wikbook.core.WikletContext;
import org.wikbook.core.WikletConverter;
import org.wikbook.core.xml.OutputFormat;
import org.wikbook.core.xml.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikBookMojo
extends AbstractMojo
implements WikletContext {
    private File sourceDirectory;
    private String sourceFileName;
    private String syntaxId;
    private File destinationDirectory;
    private String destinationFileName;
    private boolean highlightCode;
    private MavenSession session;
    private List pluginArtifacts;
    private List<String> compileSourceRoots;
    private List<String> compileClasspathElements;
    private List<String> testCompileSourceRoots;
    private List<String> testClasspathElements;

    public void execute() throws MojoExecutionException, MojoFailureException {
        WikletConverter converter;
        File src = new File(this.sourceDirectory, this.sourceFileName);
        if (!src.exists()) {
            throw new MojoFailureException("Source file " + src.getAbsolutePath() + " does not exist");
        }
        if (!src.isFile()) {
            throw new MojoFailureException("Source file " + src.getAbsolutePath() + " is not a file");
        }
        if (this.destinationDirectory.exists()) {
            if (!this.destinationDirectory.isDirectory()) {
                throw new MojoFailureException("Destination directory " + this.destinationDirectory.getAbsolutePath() + " is not a directory");
            }
        } else if (!this.destinationDirectory.mkdirs()) {
            throw new MojoFailureException("Could not create destination directory " + this.destinationDirectory.getAbsolutePath());
        }
        try {
            converter = new WikletConverter((WikletContext)this);
        }
        catch (Exception e) {
            throw new MojoFailureException("", (Throwable)e);
        }
        converter.setEmitDTD(true);
        converter.setSyntaxId(this.syntaxId);
        File destination = new File(this.destinationDirectory, this.destinationFileName);
        DOMResult dom = new DOMResult();
        converter.convert(this.sourceFileName, (Result)dom);
        Document document = (Document)dom.getNode();
        OutputStreamWriter out = null;
        try {
            String expectedXML = XML.serialize((Document)document, (OutputFormat)new OutputFormat(Integer.valueOf(2), false, "-//OASIS//DTD DocBook XML V4.5//EN", "http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd"));
            out = new FileWriter(destination);
            out.write(expectedXML);
            out.close();
        }
        catch (Exception e) {
            MojoFailureException mfe = new MojoFailureException("Could not create destination file");
            mfe.initCause((Throwable)e);
            throw mfe;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean getHighlightCode() {
        return this.highlightCode;
    }

    public List<Person> findPersonsByRole(String roleName) {
        ArrayList<Person> ps = new ArrayList<Person>();
        MavenProject project = this.session.getCurrentProject();
        for (Developer developer : project.getDevelopers()) {
            if (!developer.getRoles().contains(roleName)) continue;
            String firstName = null;
            String lastName = null;
            if (developer.getName() != null) {
                String[] names = developer.getName().trim().split("\\s+");
                if (names.length > 0) {
                    firstName = names[0];
                }
                if (names.length > 1) {
                    firstName = names[1];
                }
            }
            Person p = new Person(firstName, lastName, developer.getEmail(), developer.getOrganization(), new HashSet(developer.getRoles()));
            ps.add(p);
        }
        return ps;
    }

    public List<URL> resolveResources(ResourceType type, String id) throws IOException {
        switch (type) {
            case WIKI: {
                File f = new File(this.sourceDirectory, id);
                if (!f.exists() || !f.isFile()) break;
                return Arrays.asList(f.toURI().toURL());
            }
            case JAVA: {
                LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
                ArrayList<String> dirs = new ArrayList<String>();
                dirs.addAll(this.compileSourceRoots);
                dirs.addAll(this.compileClasspathElements);
                dirs.addAll(this.testCompileSourceRoots);
                dirs.addAll(this.testClasspathElements);
                for (String elt : dirs) {
                    File eltFile = new File(elt);
                    if (!eltFile.exists()) continue;
                    urls.add(eltFile.toURI().toURL());
                }
                for (Artifact artifact : this.session.getCurrentProject().getDependencyArtifacts()) {
                    urls.add(artifact.getFile().toURI().toURL());
                }
                URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
                Enumeration<URL> found = cl.getResources(id);
                ArrayList<URL> bilto = new ArrayList<URL>();
                while (found.hasMoreElements()) {
                    bilto.add(found.nextElement());
                }
                return bilto;
            }
        }
        return null;
    }

    public URL resolveResource(ResourceType type, String id) throws IOException {
        List<URL> found = this.resolveResources(type, id);
        return found.isEmpty() ? null : found.get(0);
    }

    public String getProperty(String propertyName) {
        Properties properties = this.session.getCurrentProject().getProperties();
        return properties.getProperty(propertyName);
    }
}

