/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.wikbook.core.ResourceType;
import org.wikbook.core.ValidationMode;
import org.wikbook.core.xml.XML;
import org.wikbook.xwiki.AbstractXDOMDocbookBuilderContext;
import org.wikbook.xwiki.WikbookConverter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikBookMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File extraSourceDirectory;
    private String sourceFileName;
    private String syntaxId;
    private File destinationDirectory;
    private String destinationFileName;
    private boolean highlightCode;
    private boolean emitDoctype;
    private String validationMode;
    private String beforeBookBodyXML;
    private String afterBookBodyXML;
    private String charset;
    private String bookId;
    private MavenSession session;
    private List pluginArtifacts;
    private List<String> compileSourceRoots;
    private List<String> compileClasspathElements;
    private List<String> testCompileSourceRoots;
    private List<String> testClasspathElements;
    private List<File> roots = null;
    private final AbstractXDOMDocbookBuilderContext context = new AbstractXDOMDocbookBuilderContext(){

        public void log(String msg) {
            WikBookMojo.this.getLog().info((CharSequence)msg);
        }

        public boolean getHighlightCode() {
            return WikBookMojo.this.highlightCode;
        }

        public ValidationMode getValidationMode() {
            if ("strict".equalsIgnoreCase(WikBookMojo.this.validationMode)) {
                return ValidationMode.STRICT;
            }
            return ValidationMode.LAX;
        }

        public List<URL> resolveResources(ResourceType type, Iterable<String> path, String id) throws IOException {
            List<URL> urls = Collections.emptyList();
            if (id.length() > 0) {
                switch (type) {
                    case WIKI: {
                        Iterator i$ = WikBookMojo.this.getRoots().iterator();
                        while (i$.hasNext()) {
                            File root;
                            File current = root = (File)i$.next();
                            for (String segment : path) {
                                File relative = new File(current, segment);
                                current = relative.getParentFile();
                            }
                            File resolved = new File(current, id);
                            if (!resolved.exists() || !resolved.isFile()) continue;
                            if (urls.isEmpty()) {
                                urls = new ArrayList<URL>();
                            }
                            urls.add(resolved.toURI().toURL());
                        }
                        break;
                    }
                    case XML: 
                    case JAVA: 
                    case DEFAULT: {
                        ArrayList dirs = new ArrayList();
                        dirs.addAll(WikBookMojo.this.compileSourceRoots);
                        dirs.addAll(WikBookMojo.this.compileClasspathElements);
                        dirs.addAll(WikBookMojo.this.testCompileSourceRoots);
                        dirs.addAll(WikBookMojo.this.testClasspathElements);
                        LinkedHashSet<URL> urlSet = new LinkedHashSet<URL>();
                        for (String elt : dirs) {
                            File eltFile = new File(elt);
                            if (!eltFile.exists()) continue;
                            urlSet.add(eltFile.toURI().toURL());
                        }
                        for (Artifact artifact : WikBookMojo.this.session.getCurrentProject().getDependencyArtifacts()) {
                            urlSet.add(artifact.getFile().toURI().toURL());
                        }
                        if (id.startsWith("/")) {
                            id = id.substring(1);
                        }
                        URLClassLoader cl = new URLClassLoader(urlSet.toArray(new URL[urlSet.size()]), ClassLoader.getSystemClassLoader());
                        urls = Collections.list(cl.getResources(id));
                    }
                }
            }
            return urls;
        }

        public String getProperty(String propertyName) {
            Properties properties = WikBookMojo.this.session.getCurrentProject().getProperties();
            return properties.getProperty(propertyName);
        }

        protected String getCharsetName() {
            return WikBookMojo.this.charset;
        }
    };

    private Iterable<File> getRoots() {
        if (this.roots == null) {
            ArrayList<File> roots = new ArrayList<File>();
            if (this.sourceDirectory != null) {
                roots.add(this.sourceDirectory);
            }
            if (this.extraSourceDirectory != null) {
                roots.add(this.extraSourceDirectory);
            }
            this.roots = roots;
        }
        return this.roots;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        WikbookConverter converter;
        File src = null;
        for (File root : this.getRoots()) {
            File f = new File(root, this.sourceFileName);
            if (!f.exists() || !f.isFile()) continue;
            src = f;
            break;
        }
        if (src == null) {
            throw new MojoFailureException("Source file " + this.sourceFileName + " is not valid");
        }
        if (this.destinationDirectory.exists()) {
            if (!this.destinationDirectory.isDirectory()) {
                throw new MojoFailureException("Destination directory " + this.destinationDirectory.getAbsolutePath() + " is not a directory");
            }
        } else if (!this.destinationDirectory.mkdirs()) {
            throw new MojoFailureException("Could not create destination directory " + this.destinationDirectory.getAbsolutePath());
        }
        try {
            converter = new WikbookConverter(this.context);
        }
        catch (Exception e) {
            throw new MojoFailureException("", (Throwable)e);
        }
        converter.setEmitDoctype(this.emitDoctype);
        converter.setSyntaxId(this.syntaxId);
        converter.setBookId(this.bookId);
        File destination = new File(this.destinationDirectory, this.destinationFileName);
        Writer out = null;
        try {
            DocumentFragment elt;
            if (WikBookMojo.hasTrimmedContent(this.beforeBookBodyXML)) {
                elt = WikBookMojo.load(this.beforeBookBodyXML);
                converter.setBeforeBookBodyXML(elt);
            }
            if (WikBookMojo.hasTrimmedContent(this.afterBookBodyXML)) {
                elt = WikBookMojo.load(this.afterBookBodyXML);
                converter.setAfterBookBodyXML(elt);
            }
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(destination), this.charset);
            StreamResult result = new StreamResult(out);
            converter.convert(this.sourceFileName, (Result)result);
        }
        catch (Exception e) {
            MojoFailureException mfe = new MojoFailureException("Could not create destination file " + e.getMessage());
            mfe.initCause((Throwable)e);
            throw mfe;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean hasTrimmedContent(String xml) {
        return xml != null && xml.trim().length() > 0;
    }

    private static DocumentFragment load(String xml) throws ParserConfigurationException, IOException, SAXException {
        xml = "<root>" + xml + "</root>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(xml)));
        DocumentFragment fragment = doc.createDocumentFragment();
        XML.copyStandaloneNodes((Node)doc.getDocumentElement(), (Node)fragment);
        return fragment;
    }
}

