/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.processing.Filer;
import org.wikbook.template.freemarker.FilerTemplateLoader;
import org.wikbook.template.freemarker.FreemarkerModelBuilder;
import org.wikbook.template.processing.metamodel.MetaModel;
import org.wikbook.template.processing.metamodel.TemplateElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerRenderer {
    private FreemarkerModelBuilder builder = new FreemarkerModelBuilder();

    public void render(MetaModel model, String templateName, TemplateElement element, OutputStream os, Filer filer) throws IOException {
        Map<String, ? extends Object> data = this.builder.build(model, element);
        this.render(data, templateName, os, filer);
    }

    public void render(MetaModel model, String templateName, OutputStream os, Filer filer) throws IOException {
        Map<String, ? extends Object> data = this.builder.build(model);
        this.render(data, templateName, os, filer);
    }

    private void render(Map<String, ? extends Object> data, String templateName, OutputStream os, Filer filer) throws IOException {
        Configuration cfg = new Configuration();
        try {
            cfg.setTemplateLoader((TemplateLoader)new FilerTemplateLoader(filer));
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            Template temp = cfg.getTemplate(templateName);
            OutputStreamWriter osw = new OutputStreamWriter(os);
            temp.process(data, (Writer)osw);
            osw.flush();
            osw.close();
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }
}

