/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.freemarker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.wikbook.template.freemarker.caller.AnnotationCallerMethod;
import org.wikbook.template.freemarker.caller.AttributeCallerMethod;
import org.wikbook.template.freemarker.caller.ChildrenCallerMethod;
import org.wikbook.template.freemarker.caller.JavadocCallerMethod;
import org.wikbook.template.freemarker.caller.SiblingCallerMethod;
import org.wikbook.template.processing.metamodel.MetaModel;
import org.wikbook.template.processing.metamodel.TemplateAnnotation;
import org.wikbook.template.processing.metamodel.TemplateType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerDataFactory {
    public static final String ATTRIBUTE = "attribute";
    public static final String JAVADOC = "doc";
    public static final String CHILDREN = "children";
    public static final String SIBLING = "sibling";
    public static final String ELEMENT_NAME = "elementName";
    public static final String ANNOTATION_NAME = "name";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String FQN = "fqn";
    public static final String IS_ARRAY = "isArray";
    public static final String ANNOTATION = "annotation";
    public static final String PARAMETER = "parameter";
    private final MetaModel model;

    public FreemarkerDataFactory(MetaModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
    }

    public Map<String, Object> create(TemplateAnnotation annotation) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(ATTRIBUTE, new AttributeCallerMethod(this, annotation.getValues()));
        data.put(JAVADOC, new JavadocCallerMethod(annotation.getJavadoc()));
        data.put(CHILDREN, new ChildrenCallerMethod(this, annotation.getChildren()));
        data.put(SIBLING, new SiblingCallerMethod(this, annotation.getElement()));
        data.put("name", annotation.getName().substring(1));
        if (annotation.getElement() != null) {
            data.put(ELEMENT_NAME, annotation.getElement().getName());
            if (annotation.getElement().getType() != null) {
                data.put(TYPE, this.createTypeData(annotation.getElement().getType()));
            }
        }
        return data;
    }

    private Map<String, Object> createTypeData(TemplateType type) {
        HashMap<String, Object> dataType = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> dataTypeParameters = new ArrayList<Map<String, Object>>();
        dataType.put("name", type.getName());
        dataType.put(FQN, type.getFqn());
        dataType.put(IS_ARRAY, type.isArray().toString());
        dataType.put(ANNOTATION, new AnnotationCallerMethod(this, type));
        dataType.put(PARAMETER, dataTypeParameters);
        for (TemplateType typeParameter : type.getParameters()) {
            dataTypeParameters.add(this.createTypeData(typeParameter));
        }
        return dataType;
    }

    public MetaModel getModel() {
        return this.model;
    }
}

