/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.freemarker;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExpression {
    private String expression;
    private String value;
    private Output output;

    private TemplateExpression() {
        this.output = Output.NOEXPR;
    }

    public TemplateExpression(String expression) {
        this.expression = expression;
        if (expression.startsWith(Output.FLAT.prefix())) {
            this.output = Output.FLAT;
            this.value = expression.substring(Output.FLAT.prefix().length());
        } else if (expression.startsWith(Output.BLOC.prefix())) {
            this.output = Output.BLOC;
            this.value = expression.substring(Output.BLOC.prefix().length());
        } else if (expression.startsWith(Output.LIST.prefix())) {
            this.output = Output.LIST;
            this.value = expression.substring(Output.LIST.prefix().length());
        } else {
            this.output = Output.NONE;
            this.value = expression;
        }
    }

    public static TemplateExpression noExpression() {
        return new TemplateExpression();
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.expression;
    }

    public Output getOutput() {
        return this.output;
    }

    public String flatStringList(List<? extends Object> l) {
        StringBuilder sb = new StringBuilder();
        for (Object object : l) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(object.toString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Output {
        FLAT{

            public String prefix() {
                return "flat:";
            }
        }
        ,
        LIST{

            public String prefix() {
                return "list:";
            }
        }
        ,
        BLOC{

            public String prefix() {
                return "bloc:";
            }
        }
        ,
        NONE{

            public String prefix() {
                return "";
            }
        }
        ,
        NOEXPR{

            public String prefix() {
                return "";
            }
        };


        public abstract String prefix();
    }
}

