/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.wikbook.core.WikbookException;
import org.wikbook.core.WikletContext;
import org.wikbook.core.model.structural.BookElement;
import org.wikbook.core.xml.DocumentEmitter;
import org.wikbook.core.xml.OutputFormat;
import org.wikbook.core.xml.XML;
import org.wikbook.core.xml.XMLEmitter;
import org.wikbook.xwiki.WikiLoader;
import org.wikbook.xwiki.XDOMTransformer;
import org.xwiki.rendering.block.Block;

public class WikletConverter {
    private final WikletContext context;
    private boolean emitDoctype;
    private String syntaxId;
    private DocumentFragment beforeBookBodyXML;
    private DocumentFragment afterBookBodyXML;

    public WikletConverter(WikletContext context) throws IOException, ClassNotFoundException {
        this.context = context;
        this.emitDoctype = true;
        this.syntaxId = null;
    }

    public boolean getEmitDoctype() {
        return this.emitDoctype;
    }

    public void setEmitDoctype(boolean emitDoctype) {
        this.emitDoctype = emitDoctype;
    }

    public String convert() {
        return this.convert("main.wiki");
    }

    public void convert(Result result) throws WikbookException {
        this.convert("main.wiki", result);
    }

    public String getSyntaxId() {
        return this.syntaxId;
    }

    public void setSyntaxId(String syntaxId) {
        this.syntaxId = syntaxId;
    }

    public DocumentFragment getBeforeBookBodyXML() {
        return this.beforeBookBodyXML;
    }

    public void setBeforeBookBodyXML(DocumentFragment beforeBookBodyXML) {
        this.beforeBookBodyXML = beforeBookBodyXML;
    }

    public DocumentFragment getAfterBookBodyXML() {
        return this.afterBookBodyXML;
    }

    public void setAfterBookBodyXML(DocumentFragment afterBookBodyXML) {
        this.afterBookBodyXML = afterBookBodyXML;
    }

    public void convert(String id, Result result) throws WikbookException {
        try {
            this._convert2(id, result);
        }
        catch (Exception e) {
            WikbookException ce = e instanceof WikbookException ? (WikbookException)e : new WikbookException((Throwable)e);
            throw ce;
        }
    }

    public String convert(String id) throws WikbookException {
        StringWriter writer = new StringWriter();
        this.convert(id, new StreamResult(writer));
        return writer.toString();
    }

    private void _convert2(String id, Result result) throws Exception {
        WikiLoader loader = new WikiLoader(this.context);
        Block main = loader.load(id, this.syntaxId);
        XDOMTransformer xdomTransformer = new XDOMTransformer(this.context);
        BookElement elt = (BookElement)xdomTransformer.transform(main);
        elt.setBeforeBodyXML(this.beforeBookBodyXML);
        elt.setAfterBodyXML(this.afterBookBodyXML);
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        elt.writeTo((XMLEmitter)new DocumentEmitter(doc));
        Transformer transformer = XML.createTransformer((OutputFormat)new OutputFormat(Integer.valueOf(2), this.emitDoctype, "-//OASIS//DTD DocBook XML V4.5//EN", "http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd"));
        transformer.transform(new DOMSource(doc), result);
    }
}

