/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.wikbook.core.WikletContext;
import org.wikbook.core.model.DocbookContext;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.Loader;
import org.wikbook.core.model.content.block.AdmonitionElement;
import org.wikbook.core.model.content.block.BlockQuotationElement;
import org.wikbook.core.model.content.block.DOMElement;
import org.wikbook.core.model.content.block.ExampleElement;
import org.wikbook.core.model.content.block.GroupElement;
import org.wikbook.core.model.content.block.ImageElement;
import org.wikbook.core.model.content.block.LanguageSyntax;
import org.wikbook.core.model.content.block.ListElement;
import org.wikbook.core.model.content.block.ListItemElement;
import org.wikbook.core.model.content.block.ListKind;
import org.wikbook.core.model.content.block.ParagraphElement;
import org.wikbook.core.model.content.block.ProgramListingElement;
import org.wikbook.core.model.content.block.ScreenElement;
import org.wikbook.core.model.content.block.TableElement;
import org.wikbook.core.model.content.block.list.TermElement;
import org.wikbook.core.model.content.block.list.VariableListElement;
import org.wikbook.core.model.content.inline.AnchorElement;
import org.wikbook.core.model.content.inline.FormatElement;
import org.wikbook.core.model.content.inline.InlineElement;
import org.wikbook.core.model.content.inline.LinkElement;
import org.wikbook.core.model.content.inline.LinkType;
import org.wikbook.core.model.content.inline.TextElement;
import org.wikbook.core.model.content.inline.TextFormat;
import org.wikbook.core.model.structural.BookElement;
import org.wikbook.core.model.structural.ComponentElement;
import org.wikbook.core.xml.OutputFormat;
import org.wikbook.core.xml.XML;
import org.wikbook.xwiki.WikiLoader;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.Image;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XDOMTransformer
implements Listener {
    private static final Set<String> admonitions = new HashSet<String>();
    private static final EnumMap<Format, TextFormat> formatMapping = new EnumMap(Format.class);
    private final WikletContext context;
    private DocbookContext bookContext;
    private BookElement book;
    final LinkedList<String> syntaxStack;
    private final Loader loader = new Loader(){

        public void load(Reader reader) {
            WikiLoader loader = new WikiLoader(XDOMTransformer.this.context);
            Block block = loader.load(reader, XDOMTransformer.this.syntaxStack.getLast());
            block.traverse((Listener)XDOMTransformer.this);
        }
    };
    private static final EnumMap<ListType, ListKind> mapping;

    public XDOMTransformer(WikletContext context) throws IOException, ClassNotFoundException {
        this.context = context;
        this.syntaxStack = new LinkedList();
    }

    public DocbookElement transform(Block block) {
        this.book = new BookElement();
        this.bookContext = new DocbookContext((DocbookElement)this.book);
        block.traverse((Listener)this);
        this.book.close();
        return this.book;
    }

    public void beginDocument(Map<String, String> parameters) {
    }

    public void endDocument(Map<String, String> parameters) {
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.book.push((DocbookElement)new ParagraphElement());
    }

    public void endParagraph(Map<String, String> parameters) {
        this.book.merge();
    }

    public void beginSection(Map<String, String> parameters) {
        this.book.push((DocbookElement)new ComponentElement());
    }

    public void endSection(Map<String, String> parameters) {
        this.book.merge();
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        ((ComponentElement)this.book.peek()).beginTitle();
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        ((ComponentElement)this.book.peek()).endTitle();
    }

    public void onWord(String word) {
        this.book.merge((DocbookElement)new TextElement(word));
    }

    public void onSpace() {
        this.book.merge((DocbookElement)new TextElement(" "));
    }

    public void onNewLine() {
        this.book.merge((DocbookElement)new TextElement(" "));
    }

    public void onSpecialSymbol(char symbol) {
        this.book.merge((DocbookElement)new TextElement(Character.toString(symbol)));
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        TextFormat textFormat = formatMapping.get(format);
        if (textFormat == null) {
            throw new UnsupportedOperationException("Format " + format + " is not yet handled");
        }
        this.book.push((DocbookElement)new FormatElement(textFormat));
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        this.book.merge();
    }

    public void beginList(ListType listType, Map<String, String> parameters) {
        String style = parameters.get("style");
        ListKind lk = mapping.get(listType);
        this.book.push((DocbookElement)new ListElement(lk, style));
    }

    public void endList(ListType listType, Map<String, String> parameters) {
        this.book.merge();
    }

    public void beginListItem() {
        this.book.push((DocbookElement)new ListItemElement());
    }

    public void endListItem() {
        this.book.merge();
    }

    public void onMacro(String id, Map<String, String> macroParameters, String content, boolean isInline) {
        DocbookElement elt = this.book.peek();
        boolean inline = elt instanceof InlineElement;
        this._onMacro(id, macroParameters, content, inline);
    }

    private void _onMacro(String id, Map<String, String> macroParameters, String content, boolean isInline) {
        if (admonitions.contains(id)) {
            AdmonitionElement admonitionElt = new AdmonitionElement(id);
            WikiLoader loader = new WikiLoader(this.context);
            Block block = loader.load(new StringReader(content), null);
            this.book.push((DocbookElement)admonitionElt);
            block.traverse((Listener)this);
            this.book.merge();
        } else if ("screen".equals(id)) {
            ScreenElement screenElt = new ScreenElement();
            this.book.push((DocbookElement)screenElt);
            screenElt.merge((DocbookElement)new TextElement(content));
            this.book.merge();
        } else if ("anchor".equals(id)) {
            String anchor = macroParameters.get("id");
            this.book.merge((DocbookElement)new AnchorElement(anchor));
        } else if ("docbook".equals(id)) {
            try {
                Transformer transformer = XML.createTransformer((OutputFormat)new OutputFormat(Integer.valueOf(2), true));
                DOMResult result = new DOMResult();
                this.book.peek();
                transformer.transform(new StreamSource(new StringReader(content)), result);
                this.book.merge((DocbookElement)new DOMElement(((Document)result.getNode()).getDocumentElement()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("code".equals(id) || "java".equals(id) || "xml".equals(id)) {
            if (isInline) {
                this.book.push((DocbookElement)new FormatElement(TextFormat.CODE));
                this.book.merge((DocbookElement)new TextElement(content));
                this.book.merge();
            } else {
                LanguageSyntax languageSyntax = LanguageSyntax.UNKNOWN;
                if ("java".equals(id)) {
                    languageSyntax = LanguageSyntax.JAVA;
                } else if ("xml".equals(id)) {
                    languageSyntax = LanguageSyntax.XML;
                } else {
                    String language = macroParameters.get("language");
                    if ("java".equalsIgnoreCase(language)) {
                        languageSyntax = LanguageSyntax.JAVA;
                    } else if ("xml".equalsIgnoreCase(language)) {
                        languageSyntax = LanguageSyntax.XML;
                    }
                }
                Integer indent = null;
                if (macroParameters.get("indent") != null) {
                    try {
                        indent = Integer.parseInt(macroParameters.get("indent"));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    ProgramListingElement programListingElt = (ProgramListingElement)this.book.push((DocbookElement)new ProgramListingElement(this.context, languageSyntax, indent, content, this.context.getHighlightCode()));
                    programListingElt.process(this.loader);
                    this.book.merge();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
            }
        } else if ("example".equals(id)) {
            if (isInline) {
                throw new UnsupportedOperationException();
            }
            WikiLoader loader = new WikiLoader(this.context);
            Block block = loader.load(new StringReader(content), this.syntaxStack.getLast());
            this.book.push((DocbookElement)new ExampleElement(macroParameters.get("title")));
            block.traverse((Listener)this);
            this.book.merge();
        } else {
            throw new UnsupportedOperationException("Unsupported macro " + id);
        }
    }

    public void beginLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        switch (link.getType()) {
            case URI: {
                LinkType type;
                String ref = link.getReference();
                if (ref.startsWith("#")) {
                    ref = ref.substring(1);
                    type = LinkType.ANCHOR;
                } else {
                    type = LinkType.URL;
                }
                this.book.push((DocbookElement)new LinkElement(type, ref));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void endLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        switch (link.getType()) {
            case URI: {
                this.book.merge();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void beginTable(Map<String, String> parameters) {
        String title = parameters.get("title");
        this.book.push((DocbookElement)new TableElement(title));
    }

    public void beginTableRow(Map<String, String> parameters) {
        ((TableElement)this.book.peek()).doBeginTableRow(parameters);
    }

    public void beginTableCell(Map<String, String> parameters) {
        ((TableElement)this.book.peek()).doBeginTableCell(parameters);
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        ((TableElement)this.book.peek()).doBeginTableHeadCell(parameters);
    }

    public void endTable(Map<String, String> parameters) {
        this.book.merge();
    }

    public void endTableRow(Map<String, String> parameters) {
        ((TableElement)this.book.peek()).doEndTableRow(parameters);
    }

    public void endTableCell(Map<String, String> parameters) {
        ((TableElement)this.book.peek()).doEndTableCell(parameters);
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        ((TableElement)this.book.peek()).doEndTableHeadCell(parameters);
    }

    public void beginGroup(Map<String, String> parameters) {
        this.book.push((DocbookElement)new GroupElement());
    }

    public void endGroup(Map<String, String> parameters) {
        this.book.merge();
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        String title = parameters.get("title");
        this.book.push((DocbookElement)new VariableListElement(title));
    }

    public void beginDefinitionTerm() {
        this.book.push((DocbookElement)new TermElement());
    }

    public void endDefinitionTerm() {
        this.book.merge();
    }

    public void beginDefinitionDescription() {
        this.book.push((DocbookElement)new ListItemElement());
    }

    public void endDefinitionDescription() {
        this.book.merge();
    }

    public void endDefinitionList(Map<String, String> parameters) {
        this.book.merge();
    }

    public void beginMacroMarker(String name, Map<String, String> macroParameters, String content, boolean isInline) {
        throw new UnsupportedOperationException();
    }

    public void endMacroMarker(String name, Map<String, String> macroParameters, String content, boolean isInline) {
        throw new UnsupportedOperationException();
    }

    public void beginQuotation(Map<String, String> parameters) {
        this.book.push((DocbookElement)new BlockQuotationElement());
    }

    public void endQuotation(Map<String, String> parameters) {
        this.book.merge();
    }

    public void beginQuotationLine() {
    }

    public void endQuotationLine() {
    }

    public void onId(String name) {
        throw new UnsupportedOperationException();
    }

    public void onHorizontalLine(Map<String, String> parameters) {
    }

    public void onEmptyLines(int count) {
    }

    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        this.book.merge((DocbookElement)new TextElement(protectedString));
    }

    public void onRawText(String rawContent, Syntax syntax) {
        throw new UnsupportedOperationException();
    }

    public void onImage(Image image, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.book.merge((DocbookElement)new ImageElement(image.getName(), parameters));
    }

    static {
        admonitions.add("note");
        admonitions.add("important");
        admonitions.add("tip");
        admonitions.add("caution");
        admonitions.add("warning");
        formatMapping.put(Format.BOLD, TextFormat.BOLD);
        formatMapping.put(Format.ITALIC, TextFormat.ITALIC);
        formatMapping.put(Format.MONOSPACE, TextFormat.MONOSPACE);
        formatMapping.put(Format.SUPERSCRIPT, TextFormat.SUPERSCRIPT);
        formatMapping.put(Format.SUBSCRIPT, TextFormat.SUBSCRIPT);
        formatMapping.put(Format.UNDERLINED, TextFormat.UNDERLINE);
        formatMapping.put(Format.STRIKEDOUT, TextFormat.STRIKE);
        mapping = new EnumMap(ListType.class);
        mapping.put(ListType.BULLETED, ListKind.BULLETED);
        mapping.put(ListType.NUMBERED, ListKind.NUMBERED);
    }
}

