/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikbook.core.ResourceType;
import org.wikbook.core.ValidationMode;
import org.wikbook.xwiki.AbstractXDOMDocbookBuilderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXDOMDocbookBuilderContext
extends AbstractXDOMDocbookBuilderContext {
    private final File base;
    private final Map<String, String> properties;
    private boolean highlightCode;
    private boolean emitDoctype;
    private ValidationMode validationMode;

    public SimpleXDOMDocbookBuilderContext(File base) {
        if (base == null) {
            throw new NullPointerException("No null base directory accepted");
        }
        this.base = base;
        this.properties = new HashMap<String, String>();
        this.emitDoctype = true;
        this.highlightCode = true;
        this.validationMode = ValidationMode.STRICT;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void log(String msg) {
        System.out.println(msg);
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (this.properties != null) {
            this.properties.put(propertyName, propertyValue);
        } else {
            this.properties.remove(propertyName);
        }
    }

    public void removeProperty(String propertyName) {
        this.setProperty(propertyName, null);
    }

    public List<URL> resolveResources(ResourceType type, String id) throws IOException {
        if (id.length() > 0) {
            switch (type) {
                case WIKI: {
                    File resolved = new File(this.base, id);
                    if (resolved == null || !resolved.isFile()) break;
                    return Arrays.asList(resolved.toURI().toURL());
                }
                case XML: {
                    if (id.startsWith("/")) {
                        id = id.substring(1);
                    }
                }
                case JAVA: {
                    Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(id);
                    ArrayList<URL> streams = new ArrayList<URL>();
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        streams.add(url);
                    }
                    return streams;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean getHighlightCode() {
        return this.highlightCode;
    }

    public void setHighlightCode(boolean highlightCode) {
        this.highlightCode = highlightCode;
    }
}

