/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.io.StringReader;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.wikbook.core.WikbookException;
import org.wikbook.core.model.DocbookBuilder;
import org.wikbook.core.model.content.block.AdmonitionKind;
import org.wikbook.core.model.content.block.LanguageSyntax;
import org.wikbook.core.model.content.block.ListKind;
import org.wikbook.core.model.content.inline.LinkType;
import org.wikbook.core.model.content.inline.TextFormat;
import org.wikbook.core.xml.OutputFormat;
import org.wikbook.core.xml.XML;
import org.wikbook.xwiki.AbstractXDOMDocbookBuilderContext;
import org.wikbook.xwiki.WikiLoader;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.Image;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XDOMTransformer
implements Listener {
    private static final Map<String, AdmonitionKind> admonitions = new HashMap<String, AdmonitionKind>();
    private static final EnumMap<Format, TextFormat> formatMapping = new EnumMap(Format.class);
    private static final EnumMap<ListType, ListKind> mapping = new EnumMap(ListType.class);
    private DocbookBuilder builder;
    final AbstractXDOMDocbookBuilderContext context;

    public XDOMTransformer(AbstractXDOMDocbookBuilderContext context, DocbookBuilder builder) {
        this.context = context;
        this.builder = builder;
    }

    public void beginDocument(Map<String, String> parameters) {
    }

    public void endDocument(Map<String, String> parameters) {
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.builder.beginParagraph();
    }

    public void endParagraph(Map<String, String> parameters) {
        this.builder.endParagraph();
    }

    public void beginSection(Map<String, String> parameters) {
        this.builder.beginSection();
    }

    public void endSection(Map<String, String> parameters) {
        this.builder.endSection();
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.builder.beginHeader();
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.builder.endHeader();
    }

    public void onWord(String word) {
        this.builder.onText(word);
    }

    public void onSpace() {
        this.builder.onText(" ");
    }

    public void onNewLine() {
        this.builder.onText(" ");
    }

    public void onSpecialSymbol(char symbol) {
        this.builder.onText(Character.toString(symbol));
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        TextFormat textFormat = formatMapping.get(format);
        if (textFormat == null) {
            this.context.onValidationError("Format " + format + " is not yet supported");
        } else {
            this.builder.beginFormat(textFormat);
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        TextFormat textFormat = formatMapping.get(format);
        if (textFormat == null) {
            this.context.onValidationError("Format " + format + " is not yet supported");
        } else {
            this.builder.endFormat(textFormat);
        }
    }

    public void beginList(ListType listType, Map<String, String> parameters) {
        String style = parameters.get("style");
        ListKind lk = mapping.get(listType);
        this.builder.beginList(lk, style);
    }

    public void endList(ListType listType, Map<String, String> parameters) {
        String style = parameters.get("style");
        ListKind lk = mapping.get(listType);
        this.builder.endList(lk, style);
    }

    public void beginListItem() {
        this.builder.beginListItem();
    }

    public void endListItem() {
        this.builder.endListItem();
    }

    public void onMacro(String id, Map<String, String> macroParameters, String content, boolean isInline) {
        this._onMacro(id, macroParameters, content, this.builder.isInlineContext());
    }

    private void _onMacro(String id, Map<String, String> macroParameters, String content, boolean isInline) {
        AdmonitionKind admonition = admonitions.get(id);
        if (admonition != null) {
            WikiLoader loader = new WikiLoader(this.context);
            Block block = loader.load(new StringReader(content), this.context.syntaxStack.getLast());
            this.builder.beginAdmonition(admonition);
            block.traverse((Listener)this);
            this.builder.endAdmonition(admonition);
        } else if ("screen".equals(id)) {
            this.builder.beginScreen();
            this.builder.onText(content);
            this.builder.endScreen();
        } else if ("anchor".equals(id)) {
            String anchor = macroParameters.get("id");
            this.builder.onAnchor(anchor);
        } else {
            if ("docbook".equals(id)) {
                try {
                    Transformer transformer = XML.createTransformer((OutputFormat)new OutputFormat(Integer.valueOf(2), true));
                    DOMResult result = new DOMResult();
                    transformer.transform(new StreamSource(new StringReader(content)), result);
                    this.builder.onDocbook(((Document)result.getNode()).getDocumentElement());
                }
                catch (Exception e) {
                    throw new WikbookException((Throwable)e);
                }
            }
            if ("code".equals(id) || "java".equals(id) || "xml".equals(id)) {
                if (isInline) {
                    this.builder.beginFormat(TextFormat.CODE);
                    this.builder.onText(content);
                    this.builder.endFormat(TextFormat.CODE);
                } else {
                    LanguageSyntax languageSyntax = LanguageSyntax.UNKNOWN;
                    if ("java".equals(id)) {
                        languageSyntax = LanguageSyntax.JAVA;
                    } else if ("xml".equals(id)) {
                        languageSyntax = LanguageSyntax.XML;
                    } else {
                        String language = macroParameters.get("language");
                        if ("java".equalsIgnoreCase(language)) {
                            languageSyntax = LanguageSyntax.JAVA;
                        } else if ("xml".equalsIgnoreCase(language)) {
                            languageSyntax = LanguageSyntax.XML;
                        }
                    }
                    Integer indent = null;
                    if (macroParameters.get("indent") != null) {
                        try {
                            indent = Integer.parseInt(macroParameters.get("indent"));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    this.builder.onCode(languageSyntax, indent, content);
                }
            } else if ("example".equals(id)) {
                if (isInline) {
                    throw new UnsupportedOperationException();
                }
                WikiLoader loader = new WikiLoader(this.context);
                Block block = loader.load(new StringReader(content), this.context.syntaxStack.getLast());
                this.builder.beginExample(macroParameters.get("title"));
                block.traverse((Listener)this);
                this.builder.endExample(macroParameters.get("title"));
            } else if ("noformat".equals(id)) {
                this.builder.onVerbatim(content);
            } else {
                this.context.onValidationError("Unsupported macro " + id);
            }
        }
    }

    public void beginLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        switch (link.getType()) {
            case URI: {
                LinkType type;
                String ref = link.getReference();
                if (ref.startsWith("#")) {
                    ref = ref.substring(1);
                    type = LinkType.ANCHOR;
                } else {
                    type = LinkType.URL;
                }
                this.builder.beginLink(type, ref);
                break;
            }
            default: {
                this.context.onValidationError("Unsupported link type " + link.getType());
            }
        }
    }

    public void endLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        switch (link.getType()) {
            case URI: {
                LinkType type;
                String ref = link.getReference();
                if (ref.startsWith("#")) {
                    ref = ref.substring(1);
                    type = LinkType.ANCHOR;
                } else {
                    type = LinkType.URL;
                }
                this.builder.endLink(type, ref);
                break;
            }
            default: {
                this.context.onValidationError("Unsupported link type " + link.getType());
            }
        }
    }

    public void beginTable(Map<String, String> parameters) {
        String title = parameters.get("title");
        this.builder.beginTable(title);
    }

    public void beginTableRow(Map<String, String> parameters) {
        this.builder.beginTableRow(parameters);
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.builder.beginTableCell(parameters);
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.builder.beginTableHeadCell(parameters);
    }

    public void endTable(Map<String, String> parameters) {
        String title = parameters.get("title");
        this.builder.endTable(title);
    }

    public void endTableRow(Map<String, String> parameters) {
        this.builder.endTableRow(parameters);
    }

    public void endTableCell(Map<String, String> parameters) {
        this.builder.endTableCell(parameters);
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.builder.endTableHeadCell(parameters);
    }

    public void beginGroup(Map<String, String> parameters) {
        this.builder.beginGroup();
    }

    public void endGroup(Map<String, String> parameters) {
        this.builder.endGroup();
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        String title = parameters.get("title");
        this.builder.beginDefinitionList(title);
    }

    public void beginDefinitionTerm() {
        this.builder.beginDefinitionTerm();
    }

    public void endDefinitionTerm() {
        this.builder.endDefinitionTerm();
    }

    public void beginDefinitionDescription() {
        this.builder.beginDefinitionDescription();
    }

    public void endDefinitionDescription() {
        this.builder.endDefinitionDescription();
    }

    public void endDefinitionList(Map<String, String> parameters) {
        String title = parameters.get("title");
        this.builder.endDefinitionList(title);
    }

    public void beginMacroMarker(String name, Map<String, String> macroParameters, String content, boolean isInline) {
        this.context.onValidationError("Not supported");
    }

    public void endMacroMarker(String name, Map<String, String> macroParameters, String content, boolean isInline) {
        this.context.onValidationError("Not supported");
    }

    public void beginQuotation(Map<String, String> parameters) {
        this.builder.beginQuotation();
    }

    public void endQuotation(Map<String, String> parameters) {
        this.builder.endQuotation();
    }

    public void beginQuotationLine() {
    }

    public void endQuotationLine() {
    }

    public void onId(String name) {
        this.context.onValidationError("Not supported");
    }

    public void onHorizontalLine(Map<String, String> parameters) {
    }

    public void onEmptyLines(int count) {
    }

    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        this.builder.onVerbatim(protectedString);
    }

    public void onRawText(String rawContent, Syntax syntax) {
        this.context.onValidationError("Not supported");
    }

    public void onImage(Image image, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.builder.onImage(image.getName(), parameters);
    }

    static {
        mapping.put(ListType.BULLETED, ListKind.BULLETED);
        mapping.put(ListType.NUMBERED, ListKind.NUMBERED);
        admonitions.put("note", AdmonitionKind.NOTE);
        admonitions.put("info", AdmonitionKind.NOTE);
        admonitions.put("important", AdmonitionKind.IMPORTANT);
        admonitions.put("tip", AdmonitionKind.TIP);
        admonitions.put("caution", AdmonitionKind.CAUTION);
        admonitions.put("warning", AdmonitionKind.WARNING);
        formatMapping.put(Format.BOLD, TextFormat.BOLD);
        formatMapping.put(Format.ITALIC, TextFormat.ITALIC);
        formatMapping.put(Format.MONOSPACE, TextFormat.MONOSPACE);
        formatMapping.put(Format.SUPERSCRIPT, TextFormat.SUPERSCRIPT);
        formatMapping.put(Format.SUBSCRIPT, TextFormat.SUBSCRIPT);
        formatMapping.put(Format.UNDERLINED, TextFormat.UNDERLINE);
        formatMapping.put(Format.STRIKEDOUT, TextFormat.STRIKE);
    }
}

