/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.wikbook.core.ResourceType;
import org.wikbook.core.Utils;
import org.wikbook.core.model.DocbookBuilder;
import org.wikbook.core.model.DocbookBuilderContext;
import org.wikbook.xwiki.WikiLoader;
import org.wikbook.xwiki.XDOMTransformer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXDOMDocbookBuilderContext
extends DocbookBuilderContext {
    final LinkedList<String> syntaxStack = new LinkedList();

    protected AbstractXDOMDocbookBuilderContext() {
    }

    protected abstract String getCharsetName();

    Reader read(Iterable<String> path, String id) throws IOException {
        URL main = this.resolveResource(ResourceType.WIKI, path, id);
        if (main == null) {
            throw new IOException("Could not load wiki document: " + id);
        }
        String charsetName = this.getCharsetName();
        if (charsetName == null) {
            throw new IOException("No charset name specified");
        }
        return Utils.read((URL)main, (String)charsetName);
    }

    public abstract List<URL> resolveResources(ResourceType var1, Iterable<String> var2, String var3) throws IOException;

    public final URL resolveResource(ResourceType type, Iterable<String> path, String id) throws IOException {
        List<URL> found = this.resolveResources(type, path, id);
        return found.isEmpty() ? null : found.get(0);
    }

    public final List<URL> resolveResources(ResourceType type, String id) throws IOException {
        return this.resolveResources(type, null, id);
    }

    public void build(Reader reader, String syntaxId, DocbookBuilder builder) {
        if (syntaxId == null) {
            syntaxId = this.syntaxStack.isEmpty() ? Syntax.XWIKI_2_0.toIdString() : this.syntaxStack.getLast();
        }
        WikiLoader loader = new WikiLoader(this);
        Block block = loader.load(reader, syntaxId);
        XDOMTransformer transformer = new XDOMTransformer(this, builder);
        block.traverse((Listener)transformer);
    }
}

