/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xwiki;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikimodel.wem.xhtml.XhtmlCharacter;
import org.wikimodel.wem.xhtml.XhtmlCharacterType;
import org.wikimodel.wem.xhtml.XhtmlEscapeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWikiXhtmlEscapeHandler
implements XhtmlEscapeHandler {
    private static final Pattern LIST_PATTERN = Pattern.compile("\\p{Blank}*((\\*+[:;]*)|([1*]+\\.[:;]*)|([:;]+))\\p{Blank}+");
    private List<String> fReservedKeywords = Arrays.asList("**", "//", "##", "--", "__", "^^", ",,", "[[", "]]", "{{", "}}");

    @Override
    public void initialize(Map<String, Object> context) {
        context.put("isPotentialList", true);
        context.put("buffer", new StringBuilder());
    }

    @Override
    public XhtmlCharacter handleCharacter(XhtmlCharacter current, Stack<XhtmlCharacter> characters, String currentTag, Map<String, Object> context) {
        XhtmlCharacter previous;
        XhtmlCharacter result = current;
        StringBuilder buffer = (StringBuilder)context.get("buffer");
        buffer.append(current.getCharacter());
        if (current.getCharacter() == '~') {
            result.setType(XhtmlCharacterType.ESCAPED);
            context.put("isPotentialList", Boolean.FALSE);
            return result;
        }
        if (current.getCharacter() == '=' && (currentTag.equals("h1") || currentTag.equals("h2") || currentTag.equals("h3") || currentTag.equals("h4") || currentTag.equals("h5") || currentTag.equals("h6"))) {
            result.setType(XhtmlCharacterType.ESCAPED);
            context.put("isPotentialList", Boolean.FALSE);
            return result;
        }
        boolean isPotentialList = (Boolean)context.get("isPotentialList");
        if (isPotentialList && current.getCharacter() == ' ' && currentTag.equals("p") && characters.size() > 0 && ((previous = characters.peek()).getCharacter() == '*' || previous.getCharacter() == '.' || previous.getCharacter() == ':' || previous.getCharacter() == ';')) {
            Matcher matcher = LIST_PATTERN.matcher(buffer);
            if (matcher.matches()) {
                XhtmlCharacter ch;
                for (int i = characters.size() - 1; i > -1 && (ch = (XhtmlCharacter)characters.elementAt(i)).getCharacter() != ' '; --i) {
                    ch.setType(XhtmlCharacterType.ESCAPED);
                }
            }
            context.put("isPotentialList", Boolean.FALSE);
        }
        if (characters.size() > 0) {
            previous = characters.peek();
            if (this.fReservedKeywords.contains("" + previous.getCharacter() + current.getCharacter())) {
                previous.setType(XhtmlCharacterType.ESCAPED);
                result.setType(XhtmlCharacterType.ESCAPED);
                return result;
            }
        }
        return result;
    }
}

