/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.util;

import java.util.ArrayList;
import java.util.List;
import org.wikimodel.wem.util.IListListener;
import org.wikimodel.wem.util.TreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBuilder {
    TreeBuilder fBuilder = new TreeBuilder(new TreeBuilder.ITreeListener(){

        public void onBeginRow(TreeBuilder.IPos n) {
            CharPos pos = (CharPos)n;
            ListBuilder.this.fListener.beginRow(pos.fTreeChar, pos.fRowChar);
        }

        public void onBeginTree(TreeBuilder.IPos n) {
            ListBuilder.this.fListener.beginTree(((CharPos)n).fTreeChar);
        }

        public void onEndRow(TreeBuilder.IPos n) {
            CharPos pos = (CharPos)n;
            ListBuilder.this.fListener.endRow(pos.fTreeChar, pos.fRowChar);
        }

        public void onEndTree(TreeBuilder.IPos n) {
            ListBuilder.this.fListener.endTree(((CharPos)n).fTreeChar);
        }
    });
    private IListListener fListener;

    public ListBuilder(IListListener listener) {
        this.fListener = listener;
    }

    public void alignContext(String row) {
        List<TreeBuilder.IPos> list = this.getCharPositions(row);
        this.fBuilder.align(list);
    }

    private List<TreeBuilder.IPos> getCharPositions(String s) {
        ArrayList<TreeBuilder.IPos> list = new ArrayList<TreeBuilder.IPos>();
        char[] array = s.toCharArray();
        int pos = 0;
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (ch == '\r' || ch == '\n') continue;
            if (!Character.isSpaceChar(ch)) {
                char treeChar = this.getTreeType(ch);
                list.add(new CharPos(treeChar, ch, pos));
            }
            ++pos;
        }
        return list;
    }

    protected char getTreeType(char rowType) {
        return rowType;
    }

    static class CharPos
    implements TreeBuilder.IPos {
        private int fPos;
        private char fRowChar;
        private char fTreeChar;

        public CharPos(char treeChar, char rowChar, int pos) {
            this.fPos = pos;
            this.fTreeChar = treeChar;
            this.fRowChar = rowChar;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CharPos)) {
                return false;
            }
            CharPos pos = (CharPos)obj;
            return this.equalsData(pos) && pos.fPos == this.fPos;
        }

        public boolean equalsData(TreeBuilder.IPos pos) {
            return ((CharPos)pos).fTreeChar == this.fTreeChar;
        }

        public int getPos() {
            return this.fPos;
        }
    }
}

