/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml;

import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.IWikiParser;
import org.wikimodel.wem.WikiParserException;
import org.wikimodel.wem.impl.WikiScannerContext;
import org.wikimodel.wem.xhtml.XhtmlEscapeHandler;
import org.wikimodel.wem.xhtml.handler.CommentHandler;
import org.wikimodel.wem.xhtml.handler.TagHandler;
import org.wikimodel.wem.xhtml.impl.LocalEntityResolver;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XhtmlParser
implements IWikiParser {
    private XhtmlEscapeHandler fEscapeHandler;
    private Map<String, TagHandler> fExtraHandlers = Collections.emptyMap();
    private CommentHandler fCommentHandler = new CommentHandler();

    public void setExtraHandlers(Map<String, TagHandler> extraHandlers) {
        this.fExtraHandlers = extraHandlers;
    }

    public void setEscapeHandler(XhtmlEscapeHandler escapeHandler) {
        this.fEscapeHandler = escapeHandler;
    }

    public void setCommentHandler(CommentHandler commentHandler) {
        this.fCommentHandler = commentHandler;
    }

    public DefaultHandler getHandler(IWemListener listener) {
        WikiScannerContext context = new WikiScannerContext(listener);
        XhtmlHandler handler = new XhtmlHandler(context, this.fExtraHandlers, this.fEscapeHandler, this.fCommentHandler);
        return handler;
    }

    @Override
    public void parse(Reader reader, IWemListener listener) throws WikiParserException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setEntityResolver(new LocalEntityResolver());
            DefaultHandler handler = this.getHandler(listener);
            xmlReader.setContentHandler(handler);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            InputSource source = new InputSource(reader);
            xmlReader.parse(source);
        }
        catch (Exception e) {
            throw new WikiParserException(e);
        }
    }
}

