/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xwiki;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikimodel.wem.xhtml.XhtmlCharacter;
import org.wikimodel.wem.xhtml.XhtmlCharacterType;
import org.wikimodel.wem.xhtml.XhtmlEscapeHandler;
import org.wikimodel.wem.xhtml.handler.TagHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWikiXhtmlEscapeHandler
implements XhtmlEscapeHandler {
    private static final Pattern LIST_PATTERN = Pattern.compile("\\p{Blank}*((\\*+[:;]*)|([1*]+\\.[:;]*)|([:;]+))\\p{Blank}+");
    private static final Pattern HEADER_PATTERN = Pattern.compile("\\p{Blank}*=+");
    private List<String> fReservedKeywords = Arrays.asList("**", "//", "##", "--", "__", "^^", ",,", "[[", "]]", "{{", "}}");

    @Override
    public void initialize(Map<String, Object> context) {
        context.put("isPotentialList", true);
        context.put("isPotentialHeader", true);
        context.put("isStillInHeader", false);
        context.put("buffer", new StringBuilder());
    }

    @Override
    public XhtmlCharacter handleCharacter(XhtmlCharacter current, Stack<XhtmlCharacter> characters, XhtmlHandler.TagStack.TagContext tagContext, Map<String, Object> context) {
        XhtmlCharacter previous;
        XhtmlCharacter ch;
        int i;
        Matcher matcher;
        XhtmlCharacter result = current;
        String currentTag = this.getTagName(tagContext);
        StringBuilder buffer = (StringBuilder)context.get("buffer");
        buffer.append(current.getCharacter());
        if (current.getCharacter() == '~') {
            result.setType(XhtmlCharacterType.ESCAPED);
            context.put("isPotentialList", Boolean.FALSE);
            context.put("isPotentialHeader", Boolean.FALSE);
            return result;
        }
        if (current.getCharacter() == '=') {
            boolean isPotentialHeader = (Boolean)context.get("isPotentialHeader");
            if (currentTag.equals("h1") || currentTag.equals("h2") || currentTag.equals("h3") || currentTag.equals("h4") || currentTag.equals("h5") || currentTag.equals("h6")) {
                result.setType(XhtmlCharacterType.ESCAPED);
                context.put("isPotentialList", Boolean.FALSE);
                context.put("isPotentialHeader", Boolean.FALSE);
                return result;
            }
            if (isPotentialHeader && currentTag.equals("p")) {
                boolean isStillInHeader = (Boolean)context.get("isStillInHeader");
                if (isStillInHeader) {
                    result.setType(XhtmlCharacterType.ESCAPED);
                } else {
                    matcher = HEADER_PATTERN.matcher(buffer);
                    if (matcher.matches()) {
                        result.setType(XhtmlCharacterType.ESCAPED);
                        for (i = characters.size() - 1; i > -1 && (ch = (XhtmlCharacter)characters.elementAt(i)).getCharacter() != ' '; --i) {
                            ch.setType(XhtmlCharacterType.ESCAPED);
                        }
                        context.put("isStillInHeader", Boolean.TRUE);
                    }
                    context.put("isPotentialList", Boolean.FALSE);
                }
            }
        } else {
            context.put("isStillInHeader", Boolean.FALSE);
        }
        boolean isPotentialList = (Boolean)context.get("isPotentialList");
        if (isPotentialList && current.getCharacter() == ' ' && currentTag.equals("p") && characters.size() > 0 && ((previous = characters.peek()).getCharacter() == '*' || previous.getCharacter() == '.' || previous.getCharacter() == ':' || previous.getCharacter() == ';')) {
            matcher = LIST_PATTERN.matcher(buffer);
            if (matcher.matches()) {
                for (i = characters.size() - 1; i > -1 && (ch = (XhtmlCharacter)characters.elementAt(i)).getCharacter() != ' '; --i) {
                    ch.setType(XhtmlCharacterType.ESCAPED);
                }
            }
            context.put("isPotentialList", Boolean.FALSE);
            context.put("isPotentialHeader", Boolean.FALSE);
        }
        if (characters.size() > 0) {
            previous = characters.peek();
            if (this.fReservedKeywords.contains("" + previous.getCharacter() + current.getCharacter())) {
                previous.setType(XhtmlCharacterType.ESCAPED);
                result.setType(XhtmlCharacterType.ESCAPED);
                context.put("isPotentialList", Boolean.FALSE);
                context.put("isPotentialHeader", Boolean.FALSE);
                return result;
            }
        }
        return result;
    }

    protected String getTagName(XhtmlHandler.TagStack.TagContext tagContext) {
        XhtmlHandler.TagStack.TagContext context = tagContext;
        TagHandler handler = context.fHandler;
        while ((handler == null || context.getLocalName().equalsIgnoreCase("span")) && context.getParent() != null) {
            context = context.getParent();
            handler = context.fHandler;
        }
        String tag = handler == null ? "p" : context.getLocalName().toLowerCase();
        return tag;
    }
}

