/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xwiki;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikimodel.wem.xhtml.XhtmlCharacter;
import org.wikimodel.wem.xhtml.XhtmlCharacterType;
import org.wikimodel.wem.xhtml.XhtmlEscapeHandler;
import org.wikimodel.wem.xhtml.handler.TagHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWikiXhtmlEscapeHandler
implements XhtmlEscapeHandler {
    private static final Pattern LIST_PATTERN = Pattern.compile("\\p{Blank}*((\\*+[:;]*)|([1*]+\\.[:;]*)|([:;]+))\\p{Blank}+");
    private static final Pattern HEADER_PATTERN = Pattern.compile("\\p{Blank}*=+");
    private static final Pattern MACRO_PATTERN = Pattern.compile("\\{\\{[^\\t\\n\\r !\"#\\$%&'\\(\\)\\*\\+,-\\.\\/\\:;<=>\\?@\\[\\\\\\]^_`\\{\\|\\}\\~]");
    private List<String> fReservedKeywords = Arrays.asList("**", "//", "##", "--", "__", "^^", ",,");

    @Override
    public void initialize(Map<String, Object> context) {
        context.put("isPotentialList", true);
        context.put("isPotentialHeader", true);
        context.put("isStillInHeader", false);
        context.put("buffer", new StringBuilder());
    }

    @Override
    public XhtmlCharacter handleCharacter(XhtmlCharacter current, Stack<XhtmlCharacter> characters, XhtmlHandler.TagStack.TagContext tagContext, Map<String, Object> context) {
        XhtmlCharacter previous;
        XhtmlCharacter ch;
        int i;
        Matcher matcher;
        XhtmlCharacter result = current;
        String currentTag = this.getTagName(tagContext);
        StringBuilder buffer = (StringBuilder)context.get("buffer");
        buffer.append(current.getCharacter());
        if (current.getCharacter() == '~') {
            result.setType(XhtmlCharacterType.ESCAPED);
            context.put("isPotentialList", false);
            context.put("isPotentialHeader", false);
            return result;
        }
        if (current.getCharacter() == '=') {
            boolean isPotentialHeader = (Boolean)context.get("isPotentialHeader");
            if (currentTag.equals("h1") || currentTag.equals("h2") || currentTag.equals("h3") || currentTag.equals("h4") || currentTag.equals("h5") || currentTag.equals("h6")) {
                result.setType(XhtmlCharacterType.ESCAPED);
                context.put("isPotentialList", false);
                context.put("isPotentialHeader", false);
                return result;
            }
            if (isPotentialHeader && currentTag.equals("p")) {
                boolean isStillInHeader = (Boolean)context.get("isStillInHeader");
                if (isStillInHeader) {
                    result.setType(XhtmlCharacterType.ESCAPED);
                } else {
                    matcher = HEADER_PATTERN.matcher(buffer);
                    if (matcher.matches()) {
                        result.setType(XhtmlCharacterType.ESCAPED);
                        for (i = characters.size() - 1; i > -1 && (ch = (XhtmlCharacter)characters.elementAt(i)).getCharacter() != ' '; --i) {
                            ch.setType(XhtmlCharacterType.ESCAPED);
                        }
                        context.put("isStillInHeader", true);
                    }
                    context.put("isPotentialList", false);
                }
            }
        } else {
            context.put("isStillInHeader", false);
        }
        boolean isPotentialList = (Boolean)context.get("isPotentialList");
        if (isPotentialList && current.getCharacter() == ' ' && currentTag.equals("p") && characters.size() > 0 && ((previous = characters.peek()).getCharacter() == '*' || previous.getCharacter() == '.' || previous.getCharacter() == ':' || previous.getCharacter() == ';')) {
            matcher = LIST_PATTERN.matcher(buffer);
            if (matcher.matches()) {
                for (i = characters.size() - 1; i > -1 && (ch = (XhtmlCharacter)characters.elementAt(i)).getCharacter() != ' '; --i) {
                    ch.setType(XhtmlCharacterType.ESCAPED);
                }
            }
            context.put("isPotentialList", false);
            context.put("isPotentialHeader", false);
        }
        if (characters.size() > 0) {
            int pos;
            if (current.getCharacter() == ']' && characters.peek().getCharacter() == ']' && (pos = buffer.indexOf("[[")) > -1) {
                ((XhtmlCharacter)characters.get(pos)).setType(XhtmlCharacterType.ESCAPED);
                ((XhtmlCharacter)characters.get(pos + 1)).setType(XhtmlCharacterType.ESCAPED);
            }
            if (current.getCharacter() == '}' && characters.peek().getCharacter() == '}') {
                Matcher matcher2 = MACRO_PATTERN.matcher(buffer);
                while (matcher2.find()) {
                    int pos2 = matcher2.start();
                    ((XhtmlCharacter)characters.get(pos2)).setType(XhtmlCharacterType.ESCAPED);
                    ((XhtmlCharacter)characters.get(pos2 + 1)).setType(XhtmlCharacterType.ESCAPED);
                }
            }
            previous = characters.peek();
            if (this.fReservedKeywords.contains("" + previous.getCharacter() + current.getCharacter())) {
                previous.setType(XhtmlCharacterType.ESCAPED);
                result.setType(XhtmlCharacterType.ESCAPED);
                context.put("isPotentialList", false);
                context.put("isPotentialHeader", false);
                return result;
            }
        }
        return result;
    }

    protected String getTagName(XhtmlHandler.TagStack.TagContext tagContext) {
        XhtmlHandler.TagStack.TagContext context = tagContext;
        TagHandler handler = context.fHandler;
        while ((handler == null || context.getName().equalsIgnoreCase("span")) && context.getParent() != null) {
            context = context.getParent();
            handler = context.fHandler;
        }
        String tag = handler == null ? "p" : context.getName().toLowerCase();
        return tag;
    }
}

