/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.impl;

import java.util.List;
import org.wikimodel.wem.WikiParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiScannerUtil {
    public static String extractSubstring(String str, String open, String close, char escape) {
        int i;
        StringBuffer buf = new StringBuffer();
        int len = str.length();
        for (i = 0; i < len; ++i) {
            if (!str.startsWith(open, i)) continue;
            i += open.length();
            break;
        }
        boolean escaped = false;
        while (i < len) {
            char ch;
            if (escaped) {
                ch = str.charAt(i);
                buf.append(ch);
                escaped = false;
            } else {
                if (str.startsWith(close, i)) break;
                ch = str.charAt(i);
                boolean bl = escaped = ch == escape;
                if (!escaped) {
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static int getNextSequence(char[] array, int pos, char[] delimiter, StringBuffer buf) {
        buf.delete(0, buf.length());
        char quot = '\u0000';
        while (pos < array.length) {
            char ch = array[pos];
            if (quot != '\u0000') {
                if (ch == quot) {
                    quot = '\u0000';
                }
            } else if (ch == '\"') {
                quot = ch;
            } else {
                int i = WikiScannerUtil.skipSequence(array, pos, delimiter);
                if (i > pos) {
                    pos = i;
                    break;
                }
            }
            buf.append(ch);
            ++pos;
        }
        return pos;
    }

    public static int getNextToken(char[] array, int pos, StringBuffer buf) {
        buf.delete(0, buf.length());
        boolean escaped = false;
        if (pos < array.length && (array[pos] == '\'' || array[pos] == '\"')) {
            char endChar = array[pos];
            ++pos;
            while (pos < array.length && (escaped || array[pos] != endChar)) {
                boolean bl = escaped = array[pos] == '\\';
                if (!escaped) {
                    buf.append(array[pos]);
                }
                ++pos;
            }
            if (pos < array.length) {
                ++pos;
            }
        } else {
            while (pos < array.length && array[pos] != '=' && !Character.isSpaceChar(array[pos]) && (escaped || array[pos] != '\'' && array[pos] != '\"')) {
                boolean bl = escaped = array[pos] == '\\';
                if (!escaped) {
                    buf.append(array[pos]);
                }
                ++pos;
            }
        }
        return pos;
    }

    public static int removeSpaces(char[] array, int pos, StringBuffer buf) {
        buf.delete(0, buf.length());
        while (pos < array.length && (array[pos] == '=' || Character.isSpaceChar(array[pos]))) {
            if (array[pos] == '=') {
                buf.append(array[pos]);
            }
            ++pos;
        }
        return pos;
    }

    public static int skipSequence(char[] array, int arrayPos, char[] sequence) {
        int j;
        int i = arrayPos;
        for (j = 0; i < array.length && j < sequence.length && array[i] == sequence[j]; ++i, ++j) {
        }
        return j == sequence.length ? i : arrayPos;
    }

    public static void splitToPairs(String str, List<WikiParameter> list) {
        WikiScannerUtil.splitToPairs(str, list, null);
    }

    public static void splitToPairs(String str, List<WikiParameter> list, String delimiter) {
        if (str == null) {
            return;
        }
        char[] array = str.toCharArray();
        char[] delimiterArray = delimiter != null ? delimiter.toCharArray() : new char[]{};
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            String key = null;
            String value = null;
            if ((i = WikiScannerUtil.removeSpaces(array, i, buf)) >= array.length) break;
            int prev = i;
            if ((i = WikiScannerUtil.skipSequence(array, i, delimiterArray)) >= array.length || i > prev && (i = WikiScannerUtil.removeSpaces(array, i, buf)) >= array.length) break;
            i = WikiScannerUtil.getNextToken(array, i, buf);
            key = buf.toString();
            i = WikiScannerUtil.removeSpaces(array, i, buf);
            if (buf.indexOf("=") >= 0) {
                i = WikiScannerUtil.getNextToken(array, i, buf);
                value = buf.toString();
            }
            WikiParameter entry = new WikiParameter(key, value);
            list.add(entry);
        }
    }

    public static String unescape(String str, char escape) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] array = str.toCharArray();
        boolean escaped = false;
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (escaped) {
                buf.append(ch);
                escaped = false;
                continue;
            }
            boolean bl = escaped = ch == escape;
            if (escaped) continue;
            buf.append(ch);
        }
        return buf.toString();
    }
}

