/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikimodel.wem.xhtml.filter.DefaultXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XHTMLWhitespaceXMLFilter
extends DefaultXMLFilter {
    private static final Pattern HTML_WHITESPACE_DUPLICATES_PATTERN = Pattern.compile("\\s{2,}|[\\t\\n\\x0B\\f\\r]+");
    private static final Pattern HTML_WHITESPACE_HEAD_PATTERN = Pattern.compile("^\\s+");
    private static final Pattern HTML_WHITESPACE_TAIL_PATTERN = Pattern.compile("\\s+$");
    private static final Set<String> NONINLINE_ELEMENTS = new HashSet<String>(Arrays.asList("address", "blockquote", "div", "dl", "dt", "dd", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "noscript", "ol", "p", "pre", "script", "table", "ul", "html", "body", "td", "tr", "th", "tbody", "head", "li", "thead", "tfoot", "caption", "col", "colgroup", "legend", "base", "link", "meta", "style", "title"));
    private static final Set<String> NONVISIBLE_ELEMENTS = new HashSet<String>(Arrays.asList("script"));
    private static final Set<String> EMPTYVISIBLE_ELEMENTS = new HashSet<String>(Arrays.asList("img"));
    private int fNoCleanUpLevel = 0;
    private StringBuffer fContent = new StringBuffer();
    private StringBuffer fPreviousInlineText = new StringBuffer();
    private String fPreviousContent = null;
    private List<Event> fPreviousElements = new ArrayList<Event>();

    public XHTMLWhitespaceXMLFilter() {
    }

    public XHTMLWhitespaceXMLFilter(XMLReader reader) {
        super(reader);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.getContent().append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (NONVISIBLE_ELEMENTS.contains(localName)) {
            this.startNonVisibleElement();
            super.startElement(uri, localName, qName, atts);
        } else if (NONINLINE_ELEMENTS.contains(localName)) {
            this.flushContent();
            if ("pre".equalsIgnoreCase(localName)) {
                ++this.fNoCleanUpLevel;
            }
            super.startElement(uri, localName, qName, atts);
        } else if (EMPTYVISIBLE_ELEMENTS.contains(localName)) {
            this.startEmptyVisibleElement();
            super.startElement(uri, localName, qName, atts);
        } else {
            this.appendInlineEvent(new Event(uri, localName, qName, new AttributesImpl(atts)));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (NONVISIBLE_ELEMENTS.contains(localName)) {
            this.endNonVisibleElement();
            super.endElement(uri, localName, qName);
            --this.fNoCleanUpLevel;
        } else if (NONINLINE_ELEMENTS.contains(localName)) {
            this.flushContent();
            if ("pre".equalsIgnoreCase(localName)) {
                --this.fNoCleanUpLevel;
            }
            super.endElement(uri, localName, qName);
        } else if (EMPTYVISIBLE_ELEMENTS.contains(localName)) {
            this.endEmptyVisibleElement();
            super.endElement(uri, localName, qName);
        } else {
            this.appendInlineEvent(new Event(uri, localName, qName));
        }
    }

    public void startCDATA() throws SAXException {
        this.startNonVisibleElement();
        super.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.endNonVisibleElement();
        super.endCDATA();
        --this.fNoCleanUpLevel;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.shouldRemoveWhiteSpaces()) {
            String comment = new String(ch, start, length);
            if (this.isSemanticComment(comment)) {
                this.startEmptyVisibleElement();
                super.comment(ch, start, length);
            } else {
                this.appendInlineEvent(new Event(comment));
            }
        } else {
            super.comment(ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
        this.flushContent();
        super.endDocument();
    }

    protected boolean shouldRemoveWhiteSpaces() {
        return this.fNoCleanUpLevel == 0;
    }

    protected void sendPreviousContent(boolean trimTrailing) throws SAXException {
        if (this.fPreviousContent != null && this.fPreviousContent.length() > 0) {
            if (trimTrailing) {
                this.fPreviousContent = this.trimTrailingWhiteSpaces(this.fPreviousContent);
            }
            this.sendCharacters(this.fPreviousContent.toCharArray());
            this.fPreviousContent = null;
        }
        for (Event event : this.fPreviousElements) {
            this.sendInlineEvent(event);
        }
        this.fPreviousElements.clear();
    }

    protected void sendInlineEvent(Event event) throws SAXException {
        if (event.type == Event.Type.BEGIN_ELEMENT) {
            super.startElement(event.uri, event.localName, event.qName, event.atts);
        } else if (event.type == Event.Type.END_ELEMENT) {
            super.endElement(event.uri, event.localName, event.qName);
        } else if (event.type == Event.Type.COMMENT) {
            super.comment(event.content.toCharArray(), 0, event.content.length());
        }
    }

    protected void flushContent() throws SAXException {
        this.cleanContentLeadingSpaces();
        this.cleanContentExtraWhiteSpaces();
        this.trimTrailingWhiteSpaces();
        this.sendPreviousContent(this.getContent().length() == 0);
        if (this.getContent().length() > 0) {
            this.sendCharacters(this.getContent().toString().toCharArray());
            this.getContent().setLength(0);
        }
        this.fPreviousInlineText.setLength(0);
    }

    protected void appendInlineEvent(Event event) throws SAXException {
        this.cleanContentLeadingSpaces();
        this.cleanContentExtraWhiteSpaces();
        if (this.getContent().length() > 0) {
            this.sendPreviousContent(false);
            this.fPreviousInlineText.append(this.getContent());
            if (this.getContent().charAt(this.getContent().length() - 1) == ' ') {
                this.fPreviousContent = this.getContent().toString();
                this.fPreviousElements.add(event);
            } else {
                this.sendCharacters(this.getContent().toString().toCharArray());
                this.sendInlineEvent(event);
            }
            this.getContent().setLength(0);
        } else if (this.fPreviousInlineText.length() == 0) {
            this.sendInlineEvent(event);
        } else {
            this.fPreviousElements.add(event);
        }
    }

    protected void startEmptyVisibleElement() throws SAXException {
        this.cleanContentLeadingSpaces();
        this.cleanContentExtraWhiteSpaces();
        this.sendPreviousContent(false);
        this.sendCharacters(this.getContent().toString().toCharArray());
        this.fPreviousInlineText.append(this.getContent());
        this.fPreviousInlineText.append("EmptyVisibleElement");
        this.getContent().setLength(0);
    }

    protected void endEmptyVisibleElement() throws SAXException {
        if (this.getContent().length() > 0) {
            this.sendCharacters(this.getContent().toString().toCharArray());
            this.getContent().setLength(0);
        }
    }

    protected void startNonVisibleElement() throws SAXException {
        if (this.shouldRemoveWhiteSpaces()) {
            this.cleanContentLeadingSpaces();
            this.cleanContentExtraWhiteSpaces();
            if (this.getContent().length() > 0) {
                this.sendPreviousContent(false);
                this.fPreviousInlineText.append(this.getContent());
                if (this.getContent().charAt(this.getContent().length() - 1) == ' ') {
                    this.fPreviousContent = this.getContent().toString();
                } else {
                    this.sendCharacters(this.getContent().toString().toCharArray());
                }
            }
            if (this.fPreviousContent != null) {
                this.sendCharacters(this.fPreviousContent.toCharArray(), 0, this.fPreviousContent.length() - 1);
                this.fPreviousContent = " ";
            }
        } else {
            this.sendCharacters(this.getContent().toString().toCharArray());
        }
        this.getContent().setLength(0);
        ++this.fNoCleanUpLevel;
    }

    protected void endNonVisibleElement() throws SAXException {
        if (this.getContent().length() > 0) {
            this.sendCharacters(this.getContent().toString().toCharArray());
            this.getContent().setLength(0);
        }
    }

    protected void sendCharacters(char[] ch) throws SAXException {
        this.sendCharacters(ch, 0, ch.length);
    }

    protected void sendCharacters(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            super.characters(ch, start, length);
        }
    }

    private void cleanContentLeadingSpaces() {
        if (this.getContent().length() > 0 && (this.fPreviousInlineText.length() == 0 || this.fPreviousInlineText.charAt(this.fPreviousInlineText.length() - 1) == ' ')) {
            this.trimLeadingWhiteSpaces();
        }
    }

    protected void cleanContentExtraWhiteSpaces() {
        if (this.getContent().length() > 0 && this.shouldRemoveWhiteSpaces()) {
            Matcher matcher = HTML_WHITESPACE_DUPLICATES_PATTERN.matcher(this.getContent());
            String result = matcher.replaceAll(" ");
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected void trimLeadingWhiteSpaces() {
        if (this.shouldRemoveWhiteSpaces() && this.getContent().length() > 0) {
            String result = this.trimLeadingWhiteSpaces(this.getContent());
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected String trimLeadingWhiteSpaces(CharSequence content) {
        String trimedContent;
        if (this.shouldRemoveWhiteSpaces() && content.length() > 0) {
            Matcher matcher = HTML_WHITESPACE_HEAD_PATTERN.matcher(content);
            trimedContent = matcher.replaceAll("");
        } else {
            trimedContent = ((Object)content).toString();
        }
        return trimedContent;
    }

    protected void trimTrailingWhiteSpaces() {
        if (this.shouldRemoveWhiteSpaces() && this.getContent().length() > 0) {
            String result = this.trimTrailingWhiteSpaces(this.getContent());
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected String trimTrailingWhiteSpaces(CharSequence content) {
        String trimedContent;
        if (this.shouldRemoveWhiteSpaces() && content.length() > 0) {
            Matcher matcher = HTML_WHITESPACE_TAIL_PATTERN.matcher(content);
            trimedContent = matcher.replaceAll("");
        } else {
            trimedContent = ((Object)content).toString();
        }
        return trimedContent;
    }

    protected StringBuffer getContent() {
        return this.fContent;
    }

    protected boolean isSemanticComment(String comment) {
        return comment.startsWith("startmacro:") || comment.startsWith("stopmacro");
    }

    private static class Event {
        public Type type;
        public String uri;
        public String localName;
        public String qName;
        public Attributes atts;
        String content;

        public Event(String uri, String localName, String qName, Attributes atts) {
            this.type = Type.BEGIN_ELEMENT;
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.atts = atts;
        }

        public Event(String uri, String localName, String qName) {
            this.type = Type.END_ELEMENT;
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
        }

        public Event(String content) {
            this.type = Type.COMMENT;
            this.content = content;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            BEGIN_ELEMENT,
            END_ELEMENT,
            COMMENT;

        }
    }
}

