/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.xhtml.handler.TagHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;

public class DivisionTagHandler
extends TagHandler {
    public DivisionTagHandler() {
        super(true, false, true);
    }

    protected String getDocumentClass() {
        return "wikimodel-document";
    }

    protected void begin(XhtmlHandler.TagStack.TagContext context) {
        WikiParameter param = context.getParams().getParameter("class");
        if (param != null) {
            List<String> classes = Arrays.asList(param.getValue().split(" "));
            if (classes.contains("wikimodel-emptyline")) {
                int value = (Integer)context.getTagStack().getStackParameter("emptyLinesCount");
                context.getTagStack().setStackParameter("emptyLinesCount", ++value);
            } else {
                this.beginDocument(context);
            }
        } else {
            this.beginDocument(context);
        }
    }

    protected void end(XhtmlHandler.TagStack.TagContext context) {
        WikiParameter param = context.getParams().getParameter("class");
        if (param != null) {
            List<String> classes = Arrays.asList(param.getValue().split(" "));
            if (!classes.contains("wikimodel-emptyline")) {
                this.endDocument(context);
            }
        } else {
            this.endDocument(context);
        }
    }

    private void beginDocument(XhtmlHandler.TagStack.TagContext context) {
        DivisionTagHandler.sendEmptyLines(context);
        context.getScannerContext().beginDocument(context.getParams().remove("class"));
        context.getTagStack().pushStackParameters();
        Stack insideBlockElementsStack = (Stack)context.getTagStack().getStackParameter("insideBlockElement");
        insideBlockElementsStack.push(false);
    }

    private void endDocument(XhtmlHandler.TagStack.TagContext context) {
        context.getTagStack().popStackParameters();
        context.getScannerContext().endDocument();
    }
}

