/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.util;

import java.util.Stack;
import org.wikimodel.wem.util.ISectionListener;
import org.wikimodel.wem.util.TreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionBuilder<T> {
    TreeBuilder<TocEntry> fBuilder = new TreeBuilder<TocEntry>(new TreeBuilder.ITreeListener<TocEntry>(){

        @Override
        public void onBeginRow(TocEntry n) {
            if (!n.fDoc) {
                SectionBuilder.this.fListener.beginSection(n);
                SectionBuilder.this.fListener.beginSectionHeader(n);
            }
        }

        @Override
        public void onBeginTree(TocEntry n) {
            if (n.fDoc) {
                SectionBuilder.this.fListener.beginDocument(n);
            }
        }

        @Override
        public void onEndRow(TocEntry n) {
            if (!n.fDoc) {
                SectionBuilder.this.fListener.endSectionContent(n);
                SectionBuilder.this.fListener.endSection(n);
            }
        }

        @Override
        public void onEndTree(TocEntry n) {
            if (n.fDoc) {
                SectionBuilder.this.fListener.endDocument(n);
            }
        }
    });
    private Stack<TocEntry> fDocEntries = new Stack();
    ISectionListener<T> fListener;

    public SectionBuilder(ISectionListener<T> listener) {
        this.fListener = listener;
    }

    private TocEntry align(int docLevel, int level, T data, boolean doc) {
        TocEntry entry = new TocEntry(docLevel, level, data, doc);
        this.fBuilder.align(entry);
        return entry;
    }

    public void beginDocument(T data) {
        TocEntry entry = this.align(this.getDocLevel() + 1, 0, data, true);
        this.fDocEntries.push(entry);
    }

    public void beginHeader(int level, T data) {
        int docLevel = this.getDocLevel();
        this.align(docLevel, level, data, false);
    }

    public void endDocument() {
        this.fDocEntries.pop();
        this.fBuilder.trim((TocEntry)((Object)this.fDocEntries));
    }

    public void endHeader() {
        TocEntry entry = this.fBuilder.getPeek();
        this.fListener.endSectionHeader(entry);
        this.fListener.beginSectionContent(entry);
    }

    private int getDocLevel() {
        return this.fDocEntries.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TocEntry
    implements TreeBuilder.IPos<TocEntry>,
    ISectionListener.IPos<T> {
        T fData;
        protected boolean fDoc;
        int fDocLevel;
        int fLevel;

        public TocEntry(int docLevel, int level, T data, boolean doc) {
            this.fDocLevel = docLevel;
            this.fLevel = level;
            this.fData = data;
            this.fDoc = doc;
        }

        @Override
        public boolean equalsData(TocEntry pos) {
            return true;
        }

        @Override
        public T getData() {
            return this.fData;
        }

        @Override
        public int getDocumentLevel() {
            return this.fDocLevel;
        }

        @Override
        public int getHeaderLevel() {
            return this.fLevel;
        }

        @Override
        public int getPos() {
            return this.fDocLevel * 10 + this.fLevel + 1;
        }
    }
}

