/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.images;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    private static BufferedImage createThumb(BufferedImage image, int thumbWidth, int thumbHeight) {
        int imageHeight;
        int imageWidth = image.getWidth(null);
        int[] size = ImageUtil.getNewSize(imageWidth, imageHeight = image.getHeight(null), thumbWidth, thumbHeight);
        if (size[0] == imageWidth && size[1] == imageHeight) {
            return image;
        }
        BufferedImage thumbImage = new BufferedImage(size[0], size[1], 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        return thumbImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createThumb(InputStream input, OutputStream output, int thumbWidth, int thumbHeight, String format) throws IOException {
        try {
            try {
                ImageInputStream imageInput = ImageIO.createImageInputStream(input);
                BufferedImage image = ImageIO.read(imageInput);
                BufferedImage thumbImage = ImageUtil.createThumb(image, thumbWidth, thumbHeight);
                ImageIO.write((RenderedImage)thumbImage, format, output);
            }
            finally {
                output.close();
            }
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getImageSize(InputStream input) throws IOException {
        try {
            ImageInputStream imageInput = ImageIO.createImageInputStream(input);
            BufferedImage image = ImageIO.read(imageInput);
            int[] nArray = new int[]{image.getWidth(), image.getHeight()};
            return nArray;
        }
        finally {
            input.close();
        }
    }

    public static int[] getImageSize(InputStream input, int maxWidth, int maxHeight) throws IOException {
        int[] size = ImageUtil.getImageSize(input);
        return ImageUtil.getNewSize(size[0], size[1], maxWidth, maxHeight);
    }

    public static int[] getNewSize(int width, int height, int maxWidth, int maxHeight) {
        if (width <= maxWidth && height <= maxHeight) {
            return new int[]{width, height};
        }
        double thumbRatio = (double)maxWidth / (double)maxHeight;
        double imageRatio = (double)width / (double)height;
        if (thumbRatio < imageRatio) {
            maxHeight = (int)((double)maxWidth / imageRatio);
        } else {
            maxWidth = (int)((double)maxHeight * imageRatio);
        }
        return new int[]{maxWidth, maxHeight};
    }
}

