/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;

public abstract class ReferenceHandler {
    public static final String PREFIX_DOWNLOAD = "download:";
    public static final String PREFIX_IMAGE = "image:";

    public void handle(WikiReference ref) {
        String link = ref.getLink();
        String label = ref.getLabel();
        WikiParameters params = ref.getParameters();
        if (params.getSize() == 0 && label == null) {
            params = params.addParameter("class", "wikimodel-freestanding");
        }
        if (link.startsWith(PREFIX_IMAGE)) {
            link = link.substring(PREFIX_IMAGE.length());
            if (label == null || "".equals(label)) {
                label = link;
            }
            this.handleImage(link, label, params);
        } else if (link.startsWith(PREFIX_DOWNLOAD)) {
            link = link.substring(PREFIX_DOWNLOAD.length());
            if (label == null || "".equals(label)) {
                label = link;
            }
            this.handleDownload(link, label, params);
        } else {
            if (label == null || "".equals(label)) {
                label = link;
            }
            this.handleReference(link, label, params);
        }
    }

    protected void handleDownload(String ref, String label, WikiParameters params) {
        this.handleReference(ref, label, params);
    }

    protected abstract void handleImage(String var1, String var2, WikiParameters var3);

    protected abstract void handleReference(String var1, String var2, WikiParameters var3);
}

