/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.as.arquillian.container.DistributionContainerConfiguration;

public class ManagedContainerConfiguration
extends DistributionContainerConfiguration {
    private String javaVmArguments = System.getProperty("jboss.options");
    private String jbossArguments;
    private String moduleOptions;
    private boolean debug = ManagedContainerConfiguration.getBooleanProperty("wildfly.debug", false);
    private int debugPort = Integer.parseInt(System.getProperty("wildfly.debug.port", "8787"));
    private boolean debugSuspend = ManagedContainerConfiguration.getBooleanProperty("wildfly.debug.suspend", true);
    private String serverConfig = System.getProperty("jboss.server.config.file.name");
    private String readOnlyServerConfig = System.getProperty("jboss.server.config.file.name.readonly");
    private boolean enableAssertions = true;
    private boolean adminOnly = false;
    private boolean setupCleanServerBaseDir = false;
    private String cleanServerBaseDir;
    private String yamlConfiguration;
    private String clientAppEar;
    private String clientArchiveName;
    private String appClientCommand;
    private boolean runClient = true;
    private Map<String, String> clientEnv = System.getenv();
    private String clientArguments;

    public void validate() throws ConfigurationException {
        super.validate();
        if (this.serverConfig != null && this.readOnlyServerConfig != null) {
            throw new ConfigurationException(String.format("Cannot define both a serverConfig and a readOnlyServerConfig: serverConfig=%s - readOnlyServerConfig=%s", this.serverConfig, this.readOnlyServerConfig));
        }
        if (this.clientAppEar != null) {
            if (this.getJbossHome() == null) {
                throw new ConfigurationException("The jbossHome is required to be set if the clientAppEar is set.");
            }
            String client = this.resolveAppClientCommand();
            Path clientExe = Path.of(this.getJbossHome(), "bin", client);
            if (Files.notExists(clientExe, new LinkOption[0])) {
                throw new ConfigurationException("Could not find appclient executable " + clientExe);
            }
        }
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public String getJbossArguments() {
        return this.jbossArguments;
    }

    public void setJbossArguments(String jbossArguments) {
        this.jbossArguments = jbossArguments;
    }

    public String getModuleOptions() {
        return this.moduleOptions;
    }

    public void setModuleOptions(String moduleOptions) {
        this.moduleOptions = moduleOptions;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public boolean isDebugSuspend() {
        return this.debugSuspend;
    }

    public void setDebugSuspend(boolean debugSuspend) {
        this.debugSuspend = debugSuspend;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public String getReadOnlyServerConfig() {
        return this.readOnlyServerConfig;
    }

    public void setReadOnlyServerConfig(String serverConfig) {
        this.readOnlyServerConfig = serverConfig;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    public void setAdminOnly(boolean adminOnly) {
        this.adminOnly = adminOnly;
    }

    public boolean isSetupCleanServerBaseDir() {
        return this.setupCleanServerBaseDir;
    }

    public void setSetupCleanServerBaseDir(boolean setupCleanServerBaseDir) {
        this.setupCleanServerBaseDir = setupCleanServerBaseDir;
    }

    public String getCleanServerBaseDir() {
        return this.cleanServerBaseDir;
    }

    public void setCleanServerBaseDir(String cleanServerBaseDir) {
        this.cleanServerBaseDir = cleanServerBaseDir;
    }

    public String getYamlConfiguration() {
        return this.yamlConfiguration;
    }

    public void setYamlConfiguration(String yamlConfiguration) {
        if (yamlConfiguration != null && !yamlConfiguration.isBlank()) {
            this.yamlConfiguration = yamlConfiguration;
        }
    }

    public String getClientArguments() {
        return this.clientArguments;
    }

    public void setClientArguments(String clientArguments) {
        this.clientArguments = clientArguments;
    }

    public String getClientAppEar() {
        return this.clientAppEar;
    }

    public void setClientAppEar(String clientAppEar) {
        this.clientAppEar = clientAppEar;
    }

    public String getClientArchiveName() {
        return this.clientArchiveName;
    }

    public void setClientArchiveName(String clientArchiveName) {
        this.clientArchiveName = clientArchiveName;
    }

    public Map<String, String> getClientEnv() {
        return this.clientEnv;
    }

    public void setClientEnv(Map<String, String> clientEnv) {
        this.clientEnv = clientEnv;
    }

    public String getAppClientCommand() {
        return this.appClientCommand;
    }

    public void setAppClientCommand(String appClientCommand) {
        this.appClientCommand = appClientCommand;
    }

    public boolean isRunClient() {
        return this.runClient;
    }

    public void setRunClient(boolean runClient) {
        this.runClient = runClient;
    }

    public String resolveAppClientCommand() {
        if (this.appClientCommand != null) {
            return this.appClientCommand;
        }
        return ManagedContainerConfiguration.isWindows() ? "appclient.bat" : "appclient.sh";
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ROOT);
        return os.contains("windows");
    }

    private static boolean getBooleanProperty(String key, boolean dft) {
        String value = System.getProperty(key);
        if (value != null) {
            return value.isBlank() || Boolean.parseBoolean(value);
        }
        return dft;
    }
}

